/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenCocobolo
extends WorldGenTree {
    public WorldGenCocobolo(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height;
        this.addLeaf(0, leafSpawn--, 0, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 1.0f, 1, this.leaf);
        if (this.height > 10) {
            this.generateAdjustedCylinder(leafSpawn--, 2.0f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(leafSpawn, 0.0f, 1, this.leaf);
        --leafSpawn;
        while (leafSpawn > 4) {
            int offset = 1;
            if (leafSpawn % 2 == 0) {
                if (this.rand.nextBoolean()) {
                    offset = -1;
                }
                this.generateAdjustedCylinder(leafSpawn, offset, 2.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            } else {
                if (this.rand.nextBoolean()) {
                    offset = -1;
                }
                this.generateAdjustedCylinder(leafSpawn, offset, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            }
            --leafSpawn;
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(8, 8);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

