/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.ITree;
import forestry.arboriculture.gadgets.ForestryBlockLeaves;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.items.ItemLeavesBlock;
import forestry.core.proxy.Proxies;
import forestry.core.render.OverlayRenderingHandler;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LeavesRenderingHandler
extends OverlayRenderingHandler
implements IItemRenderer {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileLeaves tile = ForestryBlockLeaves.getLeafTile(world, x, y, z);
        if (tile == null || tile.getTree() == null) {
            return false;
        }
        renderer.func_147784_q(block, x, y, z);
        IIcon fruitIcon = tile.getFruitTexture();
        int fruitColor = tile.getFruitColour();
        if (fruitIcon != null) {
            this.renderFruitOverlay(world, block, x, y, z, renderer, fruitIcon, fruitColor);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return PluginArboriculture.modelIdLeaves;
    }

    private boolean renderFruitOverlay(IBlockAccess world, Block block, int x, int y, int z, RenderBlocks renderer, IIcon texture, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return this.renderFruitOverlayWithColorMultiplier(world, block, x, y, z, mR, mG, mB, renderer, texture);
    }

    private boolean renderFruitOverlayWithColorMultiplier(IBlockAccess world, Block block, int x, int y, int z, float r, float g, float b, RenderBlocks renderer, IIcon texture) {
        int mixedBrightness = block.func_149677_c(world, x, y, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        this.renderBottomFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderTopFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderEastFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderWestFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderNorthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderSouthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        return true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderLeafBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                this.renderLeafBlock((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                this.renderLeafBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private ITree getTree(ItemStack itemStack) {
        return new Tree(itemStack.func_77978_p());
    }

    private void renderLeafBlock(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = StackUtils.getBlock(itemStack);
        if (!(itemStack.func_77973_b() instanceof ItemLeavesBlock) || !itemStack.func_77942_o()) {
            return;
        }
        ITree tree = this.getTree(itemStack);
        if (tree == null) {
            return;
        }
        GL11.glEnable((int)3042);
        TileLeaves leaves = new TileLeaves();
        leaves.setTree(tree);
        leaves.setDecorative();
        IIcon leavesIcon = leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        if (leavesIcon == null) {
            return;
        }
        int color = leaves.determineFoliageColour();
        float r1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r1, (float)g1, (float)b1, (float)1.0f);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (!leaves.hasFruit()) {
            return;
        }
        int fruitColor = leaves.getFruitColour();
        IIcon fruitTexture = leaves.getFruitTexture();
        if (fruitTexture == null) {
            return;
        }
        float r2 = (float)(fruitColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(fruitColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(fruitColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)r2, (float)g2, (float)b2, (float)1.0f);
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, -0.001, 0.0, fruitTexture);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.001, 0.0, fruitTexture);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, -0.001, fruitTexture);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.001, fruitTexture);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, -0.001, 0.0, 0.0, fruitTexture);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.001, 0.0, 0.0, fruitTexture);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

