/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network;

import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.network.PacketTileNBT;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketLeafUpdate
extends PacketTileNBT {
    private static short hasFruitFlag = 1;
    private static short isPollinatedFlag = (short)2;
    private byte leafState = 0;
    public short textureIndexFancy;
    public short textureIndexPlain;
    public short textureIndexFruit;
    public int colourLeaves;
    public int colourFruits;

    public PacketLeafUpdate() {
    }

    public PacketLeafUpdate(TileLeaves leaves) {
        super(90, leaves);
        this.leafState = 0;
        if (leaves.hasFruit()) {
            this.leafState = (byte)(this.leafState | hasFruitFlag);
        }
        if (leaves.isPollinated()) {
            this.leafState = (byte)(this.leafState | isPollinatedFlag);
        }
        this.textureIndexFancy = leaves.determineTextureIndex(true);
        this.textureIndexPlain = leaves.determineTextureIndex(false);
        this.textureIndexFruit = leaves.determineOverlayIndex();
        this.colourLeaves = leaves.determineFoliageColour();
        this.colourFruits = leaves.determineFruitColour();
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeByte(this.leafState);
        data.writeShort(this.textureIndexFancy);
        data.writeShort(this.textureIndexPlain);
        data.writeShort(this.textureIndexFruit);
        data.writeInt(this.colourLeaves);
        data.writeInt(this.colourFruits);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.leafState = data.readByte();
        this.textureIndexFancy = data.readShort();
        this.textureIndexPlain = data.readShort();
        this.textureIndexFruit = data.readShort();
        this.colourLeaves = data.readInt();
        this.colourFruits = data.readInt();
    }

    public boolean isFruitLeaf() {
        return (this.leafState & hasFruitFlag) > 0;
    }

    public boolean isPollinated() {
        return (this.leafState & isPollinatedFlag) > 0;
    }
}

