/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.ITree;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.inventory.AlyzerInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.plugins.PluginArboriculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemTreealyzer
extends ItemInventoried {
    public ItemTreealyzer() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabArboriculture);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.TreealyzerGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class TreealyzerInventory
    extends AlyzerInventory
    implements IErrorSource,
    IHintSource {
        public TreealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(ItemTreealyzer.class, 7, itemStack);
            this.player = player;
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return GeneticsUtil.getGeneticEquivalent(itemStack) instanceof ITree;
        }

        private void tryAnalyze() {
            ITree tree;
            ItemStack ersatz;
            if (this.inventoryStacks[1] != null || this.inventoryStacks[2] != null || this.inventoryStacks[3] != null || this.inventoryStacks[4] != null || this.inventoryStacks[6] != null) {
                return;
            }
            if (this.func_70301_a(0) == null) {
                return;
            }
            if (!PluginArboriculture.treeInterface.isMember(this.func_70301_a(0)) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.func_70301_a(0))) != null) {
                this.func_70299_a(0, ersatz);
            }
            if ((tree = PluginArboriculture.treeInterface.getMember(this.func_70301_a(0))) == null) {
                return;
            }
            if (!tree.isAnalyzed()) {
                if (!this.isEnergy(this.func_70301_a(5))) {
                    return;
                }
                tree.analyze();
                if (this.player != null) {
                    PluginArboriculture.treeInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(tree.getGenome().getPrimary());
                    PluginArboriculture.treeInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(tree.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                tree.writeToNBT(nbttagcompound);
                this.func_70301_a(0).func_77982_d(nbttagcompound);
                this.func_70298_a(5, 1);
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public void func_70296_d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("treealyzer") != null && Config.hints.get("treealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("treealyzer");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (PluginArboriculture.treeInterface.isMember(this.inventoryStacks[0]) && !this.isEnergy(this.func_70301_a(5))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

