/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.arboriculture.genetics.Tree;
import forestry.core.items.ItemForestryBlock;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemLeavesBlock
extends ItemForestryBlock {
    public ItemLeavesBlock(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack itemstack) {
        String type = StringUtil.localize("trees.grammar.leaves.type");
        if (!itemstack.func_77942_o()) {
            return type;
        }
        ITree tree = this.getTree(itemstack);
        String customTreeKey = "trees.custom.leaves." + tree.getGenome().getPrimary().getUnlocalizedName().replace("trees.species.", "");
        if (StringUtil.canTranslate(customTreeKey)) {
            return StringUtil.localize(customTreeKey);
        }
        String grammar = StringUtil.localize("trees.grammar.leaves");
        return grammar.replaceAll("%SPECIES", tree.getDisplayName()).replaceAll("%TYPE", type);
    }

    public int func_82790_a(ItemStack itemstack, int renderPass) {
        if (!itemstack.func_77942_o()) {
            return PluginArboriculture.proxy.getFoliageColorBasic();
        }
        ITree tree = this.getTree(itemstack);
        if (tree == null) {
            return PluginArboriculture.proxy.getFoliageColorBasic();
        }
        return tree.getGenome().getPrimary().getLeafColour(tree);
    }

    private ITree getTree(ItemStack itemStack) {
        return new Tree(itemStack.func_77978_p());
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!stack.func_77942_o()) {
            return false;
        }
        ITree tree = this.getTree(stack);
        if (tree == null) {
            return false;
        }
        GameProfile owner = player.func_146103_bH();
        return PluginArboriculture.treeInterface.setLeaves(world, tree, owner, x, y, z, true);
    }
}

