/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AllelePlantType;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Genome;
import forestry.plugins.PluginArboriculture;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.EnumPlantType;

public class TreeGenome
extends Genome
implements ITreeGenome {
    public TreeGenome(IChromosome[] chromosomes) {
        super(chromosomes);
    }

    public TreeGenome(NBTTagCompound nbttagcompound) {
        super(nbttagcompound);
    }

    public static IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        IAllele speciesAllele = Genome.getActiveAllele(itemStack, EnumTreeChromosome.SPECIES);
        if (speciesAllele instanceof IAlleleTreeSpecies) {
            return (IAlleleTreeSpecies)speciesAllele;
        }
        return null;
    }

    @Override
    public IAlleleTreeSpecies getPrimary() {
        return (IAlleleTreeSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES);
    }

    @Override
    public IAlleleTreeSpecies getSecondary() {
        return (IAlleleTreeSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES);
    }

    @Override
    public IFruitProvider getFruitProvider() {
        return ((IAlleleFruit)this.getActiveAllele(EnumTreeChromosome.FRUITS)).getProvider();
    }

    @Override
    public IGrowthProvider getGrowthProvider() {
        return ((IAlleleGrowth)this.getActiveAllele(EnumTreeChromosome.GROWTH)).getProvider();
    }

    @Override
    public float getHeight() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.HEIGHT)).getValue();
    }

    @Override
    public float getFertility() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.FERTILITY)).getValue();
    }

    @Override
    public float getYield() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.YIELD)).getValue();
    }

    @Override
    public float getSappiness() {
        IAllele allele;
        if (this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] == null) {
            this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] = new Chromosome(Allele.sappinessLowest);
        }
        if ((allele = this.getActiveAllele(EnumTreeChromosome.SAPPINESS)) instanceof IAlleleFloat) {
            return ((IAlleleFloat)allele).getValue();
        }
        this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] = new Chromosome(Allele.sappinessLowest);
        return 0.1f;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        if (!(this.getActiveAllele(EnumTreeChromosome.PLANT) instanceof AllelePlantType)) {
            this.getChromosomes()[EnumTreeChromosome.PLANT.ordinal()] = new Chromosome(Allele.plantTypeNone);
        }
        return ((AllelePlantType)this.getActiveAllele(EnumTreeChromosome.PLANT)).getPlantTypes();
    }

    @Override
    public int getMaturationTime() {
        if (this.getChromosomes()[EnumTreeChromosome.MATURATION.ordinal()] == null) {
            this.getChromosomes()[EnumTreeChromosome.MATURATION.ordinal()] = new Chromosome(Allele.maturationSlowest);
        }
        return ((IAlleleInteger)this.getActiveAllele(EnumTreeChromosome.MATURATION)).getValue();
    }

    private IAllele translateGirth(int girth) {
        switch (girth) {
            case 2: {
                return Allele.int2;
            }
            case 3: {
                return Allele.int3;
            }
        }
        return Allele.int1;
    }

    @Override
    public int getGirth() {
        return ((IAlleleInteger)this.getActiveAllele(EnumTreeChromosome.GIRTH)).getValue();
    }

    @Override
    public IAlleleLeafEffect getEffect() {
        return (IAlleleLeafEffect)this.getActiveAllele(EnumTreeChromosome.EFFECT);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return PluginArboriculture.treeInterface;
    }
}

