/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IMutation;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleSpecies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpecies,
IIconProvider {
    private static final HashMap<String, LeafType> leafTypes = new HashMap();
    private final ITreeRoot root;
    private Class<? extends WorldGenArboriculture> generatorClass = WorldGenBalsa.class;
    private final int primaryColour;
    private LeafType leafType;
    private int girth = 1;
    private EnumPlantType nativeType = EnumPlantType.Plains;
    private final ArrayList<IFruitFamily> fruits = new ArrayList();
    private final ItemStack wood;
    private int vanillaMap = -1;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, Class<? extends WorldGenArboriculture> generator, ItemStack wood) {
        this(uid, isDominant, name, branch, binomial, primaryColor, Utils.multiplyRGBComponents(primaryColor, 1.35f), generator, wood);
    }

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor, Class<? extends WorldGenArboriculture> generator, ItemStack wood) {
        super(uid, isDominant, "trees.species." + name, branch, binomial);
        this.root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        this.generatorClass = generator;
        this.primaryColour = primaryColor;
        this.leafType = leafTypes.get("deciduous");
        this.wood = wood;
    }

    @Override
    public ITreeRoot getRoot() {
        return this.root;
    }

    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    public AlleleTreeSpecies setGirth(int girth) {
        this.girth = girth;
        return this;
    }

    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    public AlleleTreeSpecies setLeafIndices(String ident) {
        this.leafType = leafTypes.get(ident);
        return this;
    }

    public AlleleTreeSpecies setVanillaMap(int vanillaMeta) {
        this.vanillaMap = vanillaMeta;
        return this;
    }

    @Override
    public int getComplexity() {
        return 1 + this.getGeneticAdvancement(this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!exclude.contains(iMutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(iMutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(iMutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(iMutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    public ArrayList<IFruitFamily> getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public WorldGenerator getGenerator(ITree tree, World world, int x, int y, int z) {
        try {
            return this.generatorClass.getConstructor(ITreeGenData.class).newInstance(tree);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate generator of class " + this.generatorClass.getName());
        }
    }

    @Override
    public Class<? extends WorldGenerator>[] getGeneratorClasses() {
        return new Class[]{this.generatorClass};
    }

    @Override
    public short getLeafIconIndex(ITree tree, boolean fancy) {
        if (!fancy) {
            return this.leafType.plainUID;
        }
        if (tree.getMate() != null) {
            return this.leafType.changedUID;
        }
        return this.leafType.fancyUID;
    }

    public AlleleTreeSpecies setGenerator(Class<? extends WorldGenArboriculture> generatorClass) {
        this.generatorClass = generatorClass;
        return this;
    }

    @Override
    public int getLeafColour(ITree tree) {
        return this.primaryColour;
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass == 0) {
            return this.primaryColour;
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = this.vanillaMap < 0 ? TextureManager.getInstance().registerTex(register, "germlings/sapling." + this.uid) : Blocks.field_150345_g.func_149691_a(0, this.vanillaMap);
        TextureManager.getInstance().registerTexUID(register, this.leafType.plainUID, "leaves/" + this.leafType.ident + ".plain");
        TextureManager.getInstance().registerTexUID(register, this.leafType.changedUID, "leaves/" + this.leafType.ident + ".changed");
        TextureManager.getInstance().registerTexUID(register, this.leafType.fancyUID, "leaves/" + this.leafType.ident + ".fancy");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getGermlingIcon(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return ForestryItem.pollenCluster.item().func_77618_c(0, renderPass);
        }
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.SAPLING) {
            return 0xFFFFFF;
        }
        return this.getLeafColour(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(short texUID) {
        return TextureManager.getInstance().getIcon(texUID);
    }

    @Override
    public ItemStack[] getLogStacks() {
        return new ItemStack[]{this.wood};
    }

    static {
        leafTypes.put("deciduous", new LeafType("deciduous", 10, 11, 12));
        leafTypes.put("conifers", new LeafType("conifers", 15, 16, 17));
        leafTypes.put("jungle", new LeafType("jungle", 20, 21, 22));
        leafTypes.put("willow", new LeafType("willow", 25, 26, 27));
        leafTypes.put("maple", new LeafType("maple", 30, 31, 32));
        leafTypes.put("palm", new LeafType("palm", 35, 36, 37));
    }

    private static class LeafType {
        public final String ident;
        public final short fancyUID;
        public final short plainUID;
        public final short changedUID;

        public LeafType(String ident, short fancyUID, short plainUID, short changedUID) {
            this.ident = ident;
            this.fancyUID = fancyUID;
            this.plainUID = plainUID;
            this.changedUID = changedUID;
        }
    }
}

