/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.arboriculture.network.PacketLeafUpdate;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.Allele;
import forestry.core.network.ForestryPacket;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Utils;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer,
IButterflyNursery {
    private int colourLeaves;
    private int colourFruits;
    private short textureIndexFancy = (short)48;
    private short textureIndexPlain = (short)64;
    private short textureIndexFruits = (short)-1;
    private boolean isFruitLeaf;
    private boolean isPollinatedState;
    private int ripeningTime;
    private boolean isDecorative = false;
    private int maturationTime;
    private int encumbrance;
    private BiomeGenBase biome;
    private IEffectData[] effectData = new IEffectData[2];
    private IButterfly caterpillar;

    private void updateBiome() {
        if (this.field_145850_b == null) {
            return;
        }
        this.biome = Utils.getBiomeAt(this.field_145850_b, this.field_145851_c, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isFruitLeaf = nbttagcompound.func_74767_n("FL");
        this.ripeningTime = nbttagcompound.func_74762_e("RT");
        this.encumbrance = nbttagcompound.func_74762_e("ENC");
        if (nbttagcompound.func_74764_b("CATER")) {
            this.maturationTime = nbttagcompound.func_74762_e("CATMAT");
            this.caterpillar = (IButterfly)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies").getMember(nbttagcompound.func_74775_l("CATER"));
        }
        this.isDecorative = nbttagcompound.func_74767_n("Decorative");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("FL", this.isFruitLeaf);
        nbttagcompound.func_74768_a("RT", this.ripeningTime);
        nbttagcompound.func_74768_a("ENC", this.encumbrance);
        if (this.caterpillar != null) {
            nbttagcompound.func_74768_a("CATMAT", this.maturationTime);
            NBTTagCompound subcompound = new NBTTagCompound();
            this.caterpillar.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("CATER", (NBTBase)subcompound);
        }
        nbttagcompound.func_74757_a("Decorative", this.isDecorative);
    }

    @Override
    public void onBlockTick() {
        if (this.biome == null) {
            this.updateBiome();
        }
        if (this.isDecorative || this.getTree() == null) {
            return;
        }
        boolean isDestroyed = this.isDestroyed();
        for (ILeafTickHandler tickHandler : this.getTree().getGenome().getPrimary().getRoot().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(this.getTree(), this.field_145850_b, this.biome.field_76756_M, this.field_145851_c, this.field_145848_d, this.field_145849_e, isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.encumbrance > 0) {
            --this.encumbrance;
        }
        if (this.hasFruit() && this.ripeningTime < 32766) {
            float sappiness = this.getTree().getGenome().getSappiness() * PluginArboriculture.treeInterface.getTreekeepingMode(this.field_145850_b).getSappinessModifier(this.getTree().getGenome(), 1.0f);
            if (this.field_145850_b.field_73012_v.nextFloat() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = this.getTree().doEffect(this.effectData, this.field_145850_b, this.biome.field_76756_M, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setTree(ITree tree) {
        super.setTree(tree);
        if (tree.canBearFruit()) {
            this.isFruitLeaf = tree.getGenome().getFruitProvider().markAsFruitLeaf(tree.getGenome(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.textureIndexFancy = this.determineTextureIndex(true);
        this.textureIndexPlain = this.determineTextureIndex(false);
        this.textureIndexFruits = this.determineOverlayIndex();
        this.colourLeaves = this.determineFoliageColour();
        this.colourFruits = this.determineFruitColour();
    }

    private boolean isDestroyed() {
        if (this.getTree() == null) {
            return false;
        }
        return this.encumbrance > this.getTree().getResilience();
    }

    public boolean isPollinated() {
        return !this.isDestroyed() && this.getTree() != null && this.getTree().getMate() != null;
    }

    public int getFoliageColour(EntityPlayer player) {
        return this.isPollinatedState & GeneticsUtil.hasNaturalistEye(player) ? 0xFFFFFF : this.colourLeaves;
    }

    public int getFruitColour() {
        return this.colourFruits;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(boolean fancy) {
        if (fancy) {
            return TextureManager.getInstance().getIcon(this.textureIndexFancy);
        }
        return TextureManager.getInstance().getIcon(this.textureIndexPlain);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFruitTexture() {
        if (this.textureIndexFruits >= 0) {
            return TextureManager.getInstance().getIcon(this.textureIndexFruits);
        }
        return null;
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    public void setDecorative() {
        this.isDecorative = true;
        this.ripeningTime = this.getTree().getGenome().getFruitProvider().getRipeningPeriod();
        this.colourFruits = this.determineFruitColour();
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantType() {
        if (this.getTree() == null) {
            return EnumSet.noneOf(EnumPlantType.class);
        }
        return this.getTree().getPlantTypes();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return false;
        }
        if (this.getTree().getMate() != null) {
            return false;
        }
        if (!(individual instanceof ITree)) {
            return false;
        }
        return !this.getTree().isGeneticEqual(individual);
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return;
        }
        this.getTree().mate((ITree)individual);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public IIndividual getPollen() {
        if (this.isDecorative) {
            return null;
        }
        return this.getTree();
    }

    public int determineFoliageColour() {
        if (this.getTree() == null) {
            return PluginArboriculture.proxy.getFoliageColorBasic();
        }
        int colour = this.getTree().getGenome().getPrimary().getLeafColour(this.getTree());
        if (this.isDestroyed()) {
            return Utils.addRGBComponents(colour, 92, 61, 0);
        }
        if (this.caterpillar != null) {
            return Utils.multiplyRGBComponents(colour, 1.5f);
        }
        return colour;
    }

    public int determineFruitColour() {
        if (this.getTree() == null) {
            return 0xFFFFFF;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        return fruit.getColour(this.getTree().getGenome(), (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime());
    }

    public short determineTextureIndex(boolean fancy) {
        if (this.getTree() != null) {
            return this.getTree().getGenome().getPrimary().getLeafIconIndex(this.getTree(), fancy);
        }
        return 0;
    }

    public short determineOverlayIndex() {
        if (this.getTree() == null) {
            return -1;
        }
        if (!this.hasFruit()) {
            return -1;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        if (this.getTree().getGenome().getPrimary() == Allele.treeOak && fruit == ((IAlleleFruit)((Object)Allele.fruitApple)).getProvider()) {
            return -1;
        }
        return fruit.getIconIndex(this.getTree().getGenome(), (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime(), true);
    }

    @Override
    public Packet func_145844_m() {
        return new PacketLeafUpdate(this).getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketLeafUpdate(this), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void sendNetworkUpdateRipening() {
        Proxies.net.sendNetworkPacket(new PacketRipeningUpdate(this, this.determineFruitColour()), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        super.fromPacket(packetRaw);
        PacketLeafUpdate packet = (PacketLeafUpdate)packetRaw;
        this.isFruitLeaf = packet.isFruitLeaf();
        this.isPollinatedState = packet.isPollinated();
        this.textureIndexFancy = packet.textureIndexFancy;
        this.textureIndexPlain = packet.textureIndexPlain;
        this.textureIndexFruits = packet.textureIndexFruit;
        this.colourLeaves = packet.colourLeaves;
        this.colourFruits = packet.colourFruits;
    }

    public void fromRipeningPacket(PacketRipeningUpdate packet) {
        this.colourFruits = packet.colourFruits;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !Block.func_149680_a((Block)oldBlock, (Block)newBlock);
    }

    @Override
    public Collection<ItemStack> pickFruit(ItemStack tool) {
        if (!this.hasFruit() || this.isDecorative || this.getTree() == null) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> picked = new ArrayList<ItemStack>(Arrays.asList(this.getTree().produceStacks(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime())));
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return picked;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        if (this.getTree() == null) {
            return null;
        }
        return this.getTree().getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.getTree() == null) {
            return 0.0f;
        }
        int ripeningPeriod = this.getTree().getGenome().getFruitProvider().getRipeningPeriod();
        if (ripeningPeriod == 0) {
            return 1.0f;
        }
        return (float)this.ripeningTime / (float)ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !this.isDestroyed();
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || this.isDecorative) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.getTree().getGenome().getFruitProvider().getRipeningPeriod() * add);
        this.sendNetworkUpdateRipening();
    }

    private void matureCaterpillar() {
        ++this.maturationTime;
        boolean wasDestroyed = this.isDestroyed();
        this.encumbrance += this.caterpillar.getGenome().getMetabolism();
        boolean bl = wasDestroyed = !wasDestroyed && this.isDestroyed();
        if ((float)this.maturationTime >= (float)this.caterpillar.getGenome().getLifespan() / (float)(this.caterpillar.getGenome().getFertility() * 2) && this.caterpillar.canTakeFlight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            }
            this.setCaterpillar(null);
        } else if (wasDestroyed) {
            this.sendNetworkUpdate();
        }
    }

    private void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        if (((IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies")).spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z) != null) {
            Proxies.log.finest("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), x, y, z);
        }
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public int getBiomeId() {
        return this.biome.field_76756_M;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.biome;
    }

    @Override
    public EnumTemperature getTemperature() {
        return null;
    }

    @Override
    public EnumHumidity getHumidity() {
        return null;
    }

    @Override
    public void setErrorState(int state) {
    }

    @Override
    public void setErrorState(IErrorState state) {
    }

    @Override
    public int getErrorOrdinal() {
        return 0;
    }

    @Override
    public EnumErrorCode getErrorState() {
        return null;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        return false;
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        if (this.isDecorative) {
            return;
        }
        this.maturationTime = 0;
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly butterfly) {
        return !this.isDecorative && !this.isDestroyed() && this.caterpillar == null;
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwnerProfile();
    }
}

