/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArbStairs
extends BlockStairs {
    public BlockArbStairs(Block par2Block, int par3) {
        super(par2Block, par3);
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
    }

    public static TileStairs getStairTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileStairs)) {
            return null;
        }
        return (TileStairs)tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (WoodType type : WoodType.VALUES) {
            ItemStack stack = new ItemStack(item, 1, 0);
            NBTTagCompound compound = new NBTTagCompound();
            type.saveToCompound(compound);
            stack.func_77982_d(compound);
            list.add(stack);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, meta) && !player.field_71075_bZ.field_75098_d && (tile = world.func_147438_o(x, y, z)) instanceof TileStairs) {
            TileStairs stairs = (TileStairs)tile;
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            NBTTagCompound compound = new NBTTagCompound();
            stairs.getType().saveToCompound(compound);
            stack.func_77982_d(compound);
            StackUtils.dropItemStackAsEntity(stack, world, x, y, z);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        world.func_147475_p(x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileStairs();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z, player);
        NBTTagCompound stairsNBT = BlockArbStairs.getTagCompoundForStairs((IBlockAccess)world, x, y, z);
        itemStack.func_77982_d(stairsNBT);
        return itemStack;
    }

    private static NBTTagCompound getTagCompoundForStairs(IBlockAccess world, int x, int y, int z) {
        TileStairs stairs = BlockArbStairs.getStairTile(world, x, y, z);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (stairs == null || stairs.getType() == null) {
            return nbttagcompound;
        }
        stairs.getType().saveToCompound(nbttagcompound);
        return nbttagcompound;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileStairs stairs = BlockArbStairs.getStairTile(world, x, y, z);
        if (stairs != null && stairs.getType() != null) {
            return stairs.getType().getPlankIcon();
        }
        return WoodType.LARCH.getPlankIcon();
    }

    public boolean func_149710_n() {
        return true;
    }
}

