/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.core.render.TextureManager;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderNone
implements IFruitProvider {
    private static HashMap<String, OverlayType> overlayTypes = new HashMap();
    private final String key;
    private final IFruitFamily family;
    int ripeningPeriod = 10;
    OverlayType overlay = null;

    public FruitProviderNone(String key, IFruitFamily family) {
        this.key = key;
        this.family = family;
    }

    public IFruitProvider setOverlay(String ident) {
        this.overlay = overlayTypes.get(ident);
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    @Override
    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        return new ItemStack[0];
    }

    @Override
    public boolean requiresFruitBlocks() {
        return false;
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, int x, int y, int z) {
        return false;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        return 0xFFFFFF;
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return false;
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    @Override
    public ItemStack[] getProducts() {
        return new ItemStack[0];
    }

    @Override
    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    @Override
    public String getDescription() {
        return "fruits." + this.key;
    }

    @Override
    public short getIconIndex(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime, boolean fancy) {
        if (this.overlay != null) {
            return this.overlay.texUID;
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        if (this.overlay != null) {
            TextureManager.getInstance().registerTexUID(register, this.overlay.texUID, "leaves/fruits." + this.overlay.ident);
        }
    }

    static {
        overlayTypes.put("berries", new OverlayType("berries", 1000));
        overlayTypes.put("pomes", new OverlayType("pomes", 1001));
        overlayTypes.put("nuts", new OverlayType("nuts", 1002));
        overlayTypes.put("citrus", new OverlayType("citrus", 1003));
        overlayTypes.put("plums", new OverlayType("plums", 1004));
    }

    private static class OverlayType {
        public final String ident;
        public final short texUID;

        public OverlayType(String ident, short texUID) {
            this.ident = ident;
            this.texUID = texUID;
        }
    }
}

