/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.core.config.ForestryBlock;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public enum HiveDescription implements IHiveDescription
{
    FOREST(1, 3.0f, EnumSet.of(EnumHumidity.NORMAL), EnumSet.of(EnumTemperature.NORMAL), HiveManager.genHelper.tree()),
    MEADOWS(2, 1.0f, EnumSet.of(EnumHumidity.NORMAL), EnumSet.of(EnumTemperature.NORMAL), HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c})),
    DESERT(3, 1.0f, EnumSet.of(EnumHumidity.ARID), EnumSet.of(EnumTemperature.HOT), HiveManager.genHelper.ground(new Block[]{Blocks.field_150354_m, Blocks.field_150322_A})),
    JUNGLE(4, 4.0f, EnumSet.of(EnumHumidity.DAMP), EnumSet.of(EnumTemperature.WARM), HiveManager.genHelper.tree()),
    END(5, 4.0f, (EnumSet)EnumSet.allOf(EnumHumidity.class), (EnumSet)EnumSet.allOf(EnumTemperature.class), HiveManager.genHelper.ground(Blocks.field_150377_bs)){

        @Override
        public boolean isGoodBiome(BiomeGenBase biome) {
            return biome.field_76756_M == BiomeGenBase.field_76779_k.field_76756_M;
        }
    }
    ,
    SNOW(6, 2.0f, (EnumSet)EnumSet.allOf(EnumHumidity.class), (EnumSet)EnumSet.of(EnumTemperature.COLD, EnumTemperature.ICY), HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150433_aE})){

        @Override
        public void postGen(World world, int x, int y, int z) {
            if (world.func_147437_c(x, y + 1, z)) {
                world.func_147465_d(x, y + 1, z, Blocks.field_150431_aC, 0, 0);
            }
        }
    }
    ,
    SWAMP(7, 2.0f, EnumSet.of(EnumHumidity.DAMP), EnumSet.of(EnumTemperature.NORMAL), HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}));

    private final int meta;
    private final float genChance;
    private final EnumSet<EnumHumidity> humidities;
    private final EnumSet<EnumTemperature> temperatures;
    private final IHiveGen hiveGen;

    private HiveDescription(int meta, float genChance, EnumSet<EnumHumidity> humidities, EnumSet<EnumTemperature> temperatures, IHiveGen hiveGen) {
        this.meta = meta;
        this.genChance = genChance;
        this.humidities = humidities;
        this.temperatures = temperatures;
        this.hiveGen = hiveGen;
    }

    @Override
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @Override
    public Block getBlock() {
        return ForestryBlock.beehives.block();
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public boolean isGoodBiome(BiomeGenBase biome) {
        return !BiomeHelper.isBiomeHellish(biome);
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        return this.humidities.contains((Object)humidity);
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        return this.temperatures.contains((Object)temperature);
    }

    @Override
    public float getGenChance() {
        return this.genChance;
    }

    @Override
    public void postGen(World world, int x, int y, int z) {
    }
}

