/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.apiculture.render.TextureBiomefinder;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.vect.Vect;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemBiomefinder
extends ItemInventoried {
    public ItemBiomefinder() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabApiculture);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.HabitatLocatorGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public void startBiomeSearch(World world, EntityPlayer player, ArrayList<Integer> biomesToSearch) {
        ArrayList<Integer> excludedBiomes = new ArrayList<Integer>();
        excludedBiomes.add(BiomeGenBase.field_76771_b.field_76756_M);
        excludedBiomes.add(BiomeGenBase.field_76776_l.field_76756_M);
        excludedBiomes.add(BiomeGenBase.field_76787_r.field_76756_M);
        biomesToSearch.removeAll(excludedBiomes);
        BiomeGenBase biome = world.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v);
        if (biomesToSearch.contains(biome.field_76756_M)) {
            Proxies.common.setBiomefinderCoordinates(player, new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
            return;
        }
        if (Proxies.common.isSimulating(world) && biomesToSearch.size() > 0) {
            ChunkCoordinates target = this.findNearestBiome(player, biomesToSearch);
            Proxies.common.setBiomefinderCoordinates(player, target);
        }
    }

    private ChunkCoordinates findNearestBiome(EntityPlayer player, ArrayList<Integer> biomesToSearch) {
        int loadChunkDistance = 25;
        ChunkCoordinates coordinates = null;
        Vect pos = new Vect((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        for (int i = 0; i < 100; ++i) {
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 0)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, -10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 0)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, -10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, 10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, -10 * i)), player.field_70170_p, biomesToSearch, i < loadChunkDistance);
            if (coordinates == null) continue;
            return coordinates;
        }
        return coordinates;
    }

    private ChunkCoordinates getChunkCoordinates(Vect pos, World world, ArrayList<Integer> biomesToSearch, boolean loadChunks) {
        BiomeGenBase biome = world.func_72807_a(pos.x, pos.z);
        if (biomesToSearch.contains(biome.field_76756_M)) {
            return new ChunkCoordinates(pos.x, pos.y, pos.z);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureBiomefinder texture = new TextureBiomefinder();
            ((TextureMap)register).setTextureEntry("forestry:biomefinder", (TextureAtlasSprite)texture);
            this.field_77791_bV = texture;
        }
    }

    public static class BiomefinderInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        public ArrayList<Integer> biomesToSearch = new ArrayList();
        private final short energySlot = (short)2;
        private final short specimenSlot = 0;
        private final short analyzeSlot = 1;

        public BiomefinderInventory(ItemStack itemstack) {
            super(ItemBiomefinder.class, 3, itemstack);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 2; i < this.inventoryStacks.length; ++i) {
                if (this.inventoryStacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.inventoryStacks[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }

        private boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.field_77994_a <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        private void tryAnalyze() {
            if (this.inventoryStacks[1] != null) {
                return;
            }
            if (this.func_70301_a(0) == null) {
                return;
            }
            IBee bee = PluginApiculture.beeInterface.getMember(this.func_70301_a(0));
            if (bee == null) {
                return;
            }
            if (!this.isEnergy(this.func_70301_a(2))) {
                return;
            }
            this.biomesToSearch = bee.getSuitableBiomeIds();
            this.func_70298_a(2, 1);
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public void func_70296_d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("habitatlocator") != null && Config.hints.get("habitatlocator").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("habitatlocator");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (PluginApiculture.beeInterface.isMember(this.inventoryStacks[0]) && !this.isEnergy(this.func_70301_a(2))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 2) {
                Item item = itemStack.func_77973_b();
                return item == ForestryItem.honeydew.item() || item == ForestryItem.honeyDrop.item();
            }
            if (slotIndex == 0 || slotIndex == 1) {
                return PluginApiculture.beeInterface.isMember(itemStack);
            }
            return false;
        }
    }
}

