/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.inventory.AlyzerInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBeealyzer
extends ItemInventoried {
    public ItemBeealyzer() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabApiculture);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BeealyzerGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class BeealyzerInventory
    extends AlyzerInventory
    implements IErrorSource,
    IHintSource {
        public BeealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(ItemBeealyzer.class, 7, itemStack);
            this.player = player;
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return PluginApiculture.beeInterface.isMember(itemStack);
        }

        private void tryAnalyze() {
            if (this.func_70301_a(0) == null) {
                return;
            }
            IBee bee = PluginApiculture.beeInterface.getMember(this.func_70301_a(0));
            if (bee == null) {
                return;
            }
            if (!bee.isAnalyzed()) {
                if (!this.isEnergy(this.func_70301_a(5))) {
                    return;
                }
                bee.analyze();
                if (this.player != null) {
                    PluginApiculture.beeInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(bee.getGenome().getPrimary());
                    PluginApiculture.beeInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(bee.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                bee.writeToNBT(nbttagcompound);
                this.func_70301_a(0).func_77982_d(nbttagcompound);
                this.func_70298_a(5, 1);
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public void func_70296_d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("beealyzer") != null && Config.hints.get("beealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("beealyzer");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (PluginApiculture.beeInterface.isMember(this.inventoryStacks[0]) && !this.isEnergy(this.func_70301_a(5))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

