/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.core.genetics.Mutation;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BeeMutation
extends Mutation
implements IBeeMutation {
    private final IBeeRoot root;
    boolean requiresDay = false;
    boolean requiresNight = false;
    private final ArrayList<BiomeDictionary.Type> restrictBiomeTypes = new ArrayList();
    private boolean strictBiomeCheck = false;

    public BeeMutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        super(allele0, allele1, template, chance);
        this.root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        PluginApiculture.beeInterface.registerMutation(this);
    }

    @Override
    public IBeeRoot getRoot() {
        return this.root;
    }

    public BeeMutation enableStrictBiomeCheck() {
        this.strictBiomeCheck = true;
        return this;
    }

    public BeeMutation restrictBiomeType(BiomeDictionary.Type type) {
        this.restrictBiomeTypes.add(type);
        this.specialConditions.add(String.format("Is restricted to %s-like environments.", type.toString()));
        return this;
    }

    public BeeMutation requireDay() {
        this.requiresDay = true;
        this.requiresNight = false;
        this.specialConditions.add("Can only occur during the day.");
        return this;
    }

    public BeeMutation requireNight() {
        this.requiresDay = false;
        this.requiresNight = true;
        this.specialConditions.add("Can only occur during the night.");
        return this;
    }

    @Override
    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        World world;
        block9: {
            boolean noneMatched;
            block11: {
                BiomeGenBase biome;
                block10: {
                    world = housing.getWorld();
                    if (this.requiresDay && !world.func_72935_r()) {
                        return 0.0f;
                    }
                    if (this.requiresNight && world.func_72935_r()) {
                        return 0.0f;
                    }
                    if (this.restrictBiomeTypes.size() <= 0) break block9;
                    noneMatched = true;
                    biome = BiomeGenBase.func_150568_d((int)housing.getBiomeId());
                    if (!this.strictBiomeCheck) break block10;
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                    if (types.length != 1 || !this.restrictBiomeTypes.contains(types[0])) break block11;
                    noneMatched = false;
                    break block11;
                }
                for (BiomeDictionary.Type type : this.restrictBiomeTypes) {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return 0.0f;
            }
        }
        BiomeGenBase biome = world.func_72959_q().func_76935_a(housing.getXCoord(), housing.getZCoord());
        if (biome.field_76750_F < this.minTemperature || biome.field_76750_F > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.field_76751_G < this.minRainfall || biome.field_76751_G > this.maxRainfall) {
            return 0.0f;
        }
        float processedChance = (float)this.chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f) * PluginApiculture.beeInterface.getBeekeepingMode(world).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f);
        if (processedChance <= 0.0f) {
            return 0.0f;
        }
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

