/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.genetics.EffectData;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class AlleleEffectCreeper
extends AlleleEffectThrottled {
    private static final int explosionChance = 50;
    private static final byte defaultForce = 12;
    private final byte indexExplosionTimer = 1;
    private final byte indexExplosionForce = (byte)2;

    public AlleleEffectCreeper(String uid) {
        super(uid, "creeper", true, 20, false, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            return new EffectData(3, 0);
        }
        if (((EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        if (storedData.getInteger(1) > 0) {
            this.progressExplosion(storedData, world, housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
            return storedData;
        }
        AxisAlignedBB infectionBox = this.getBounding(genome, housing, 1.0f);
        List list = world.func_72872_a(EntityPlayer.class, infectionBox);
        for (Object obj : list) {
            EntityPlayer player = (EntityPlayer)obj;
            int chance = 50;
            storedData.setInteger(2, 12);
            int count = ItemArmorApiarist.wearsItems(player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(2, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(2, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(2, 10);
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            world.func_72908_a((double)housing.getXCoord(), (double)housing.getYCoord(), (double)housing.getZCoord(), "mob.creeper", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            storedData.setInteger(1, 2);
        }
        return storedData;
    }

    private void progressExplosion(IEffectData storedData, World world, int x, int y, int z) {
        int explosionTimer = storedData.getInteger(1);
        storedData.setInteger(1, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)storedData.getInteger(2), false);
    }
}

