/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IClimatised;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.Utils;
import forestry.plugins.PluginApiculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileBeehouse
extends TileBase
implements IBeeHousing,
IClimatised {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_2 = 10;
    public static final int SLOT_FRAMES_3 = 11;
    public static final int SLOT_FRAMES_COUNT = 3;
    private final IBeekeepingLogic logic;
    private BiomeGenBase biome;
    private int displayHealthMax = 0;
    private int displayHealth = 0;

    public TileBeehouse() {
        this.setHints(Config.hints.get("apiary"));
        this.logic = PluginApiculture.beeInterface.createBeekeepingLogic(this);
        this.setInternalInventory(new BeehouseInventoryAdapter(this, 12, "Items").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BeehouseGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("BiomeId", this.biome.field_76756_M);
        if (this.logic != null) {
            this.logic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int biomeId = nbttagcompound.func_74762_e("BiomeId");
        this.biome = BiomeGenBase.func_150568_d((int)biomeId);
        this.logic.readFromNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBiome();
    }

    @Override
    public void func_145829_t() {
        this.updateBiome();
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.biome);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.biome.field_76750_F;
    }

    @Override
    public float getExactHumidity() {
        return this.biome.field_76751_G;
    }

    @Override
    public void updateClientSide() {
        if (PluginApiculture.beeInterface.isMated(this.getInternalInventory().func_70301_a(0)) && this.getErrorState() == EnumErrorCode.OK && this.field_145850_b.func_82737_E() % 2L % 2L == 0L) {
            IBee displayQueen = PluginApiculture.beeInterface.getMember(this.getInternalInventory().func_70301_a(0));
            displayQueen.doFX(this.logic.getEffectData(), this);
        }
    }

    @Override
    public void updateServerSide() {
        this.logic.update();
        IBee queen = this.logic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 200L * 10L == 0L) {
            this.onQueenChange(this.getInternalInventory().func_70301_a(0));
        }
    }

    public boolean isWorking() {
        return this.getErrorState() == EnumErrorCode.OK;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        return InvTools.tryAddStack((IInventory)this.getInternalInventory(), product, 2, 7, all, true);
    }

    @Override
    public void onQueenChange(ItemStack queenStack) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(3, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, queenStack), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Proxies.net.sendNetworkPacket(new PacketTileUpdate(this), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int getHealthDisplay() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (ForestryItem.beeQueenGE.isItemEqual(inventory.func_70301_a(0))) {
            return PluginApiculture.beeInterface.getMember(inventory.func_70301_a(0)).getHealth();
        }
        if (ForestryItem.beePrincessGE.isItemEqual(inventory.func_70301_a(0))) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (ForestryItem.beeQueenGE.isItemEqual(inventory.func_70301_a(0))) {
            return PluginApiculture.beeInterface.getMember(inventory.func_70301_a(0)).getMaxHealth();
        }
        if (ForestryItem.beePrincessGE.isItemEqual(inventory.func_70301_a(0))) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.getExactTemperature() / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.getExactHumidity());
    }

    public void updateBiome() {
        BiomeGenBase biome;
        if (this.field_145850_b != null && (biome = Utils.getBiomeAt(this.field_145850_b, this.field_145851_c, this.field_145849_e)) != null) {
            this.biome = biome;
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    public void getGUINetworkData(int i, int j) {
        if (this.logic == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.logic == null) {
            return;
        }
        iCrafting.func_71112_a(container, 0, this.logic.getBreedingTime());
        iCrafting.func_71112_a(container, 1, this.logic.getTotalBreedingTime());
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public int getBiomeId() {
        return this.biome.field_76756_M;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.biome;
    }

    @Override
    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    @Override
    public void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().getID();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return 0.25f;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 0.0f;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }

    @Override
    public void onQueenDeath(IBee queen) {
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        return false;
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwnerProfile();
    }

    protected static class BeehouseInventoryAdapter
    extends TileInventoryAdapter {
        public BeehouseInventoryAdapter(TileForestry tile, int size, String name) {
            super(tile, size, name);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return PluginApiculture.beeInterface.isMember(itemStack) && !PluginApiculture.beeInterface.isDrone(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 9, 3)) {
                return itemStack.func_77973_b() instanceof IHiveFrame;
            }
            if (slotIndex == 1) {
                return PluginApiculture.beeInterface.isDrone(itemStack);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return GuiUtil.isIndexInRange(slotIndex, 2, 7);
        }
    }
}

