/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.plugins.PluginApiculture;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileApiary
extends TileBeehouse {
    public TileApiary() {
        this.setInternalInventory(new TileBeehouse.BeehouseInventoryAdapter(this, 12, "Items"));
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 0.1f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        IInventoryAdapter inventory = this.getInternalInventory();
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public void wearOutEquipment(int amount) {
        IInventoryAdapter inventory = this.getInternalInventory();
        int wear = Math.round((float)amount * PluginApiculture.beeInterface.getBeekeepingMode(this.field_145850_b).getWearModifier());
        for (int i = 9; i < 12; ++i) {
            if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            inventory.func_70299_a(i, ((IHiveFrame)inventory.func_70301_a(i).func_77973_b()).frameUsed(this, inventory.func_70301_a(i), PluginApiculture.beeInterface.getMember(inventory.func_70301_a(0)), wear));
        }
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        res.add(ApicultureTriggers.noFrames);
        return res;
    }
}

