/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import cofh.api.energy.IEnergyHandler;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.network.PacketPayload;
import forestry.energy.EnergyManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IEnergyHandler {
    protected final EnergyManager energyManager;
    private final ClimateControl climateControl;
    private int workingTime = 0;
    private final int textureOff;
    private final int textureOn;

    public TileAlvearyClimatiser(ClimateControl control, int textureOff, int textureOn, int componentBlockMeta) {
        super(componentBlockMeta);
        this.climateControl = control;
        this.energyManager = new EnergyManager(1000, 50, 2000);
        this.energyManager.setReceiveOnly();
        this.textureOff = textureOff;
        this.textureOn = textureOn;
    }

    @Override
    public void openGui(EntityPlayer player) {
    }

    @Override
    protected void updateServerSide() {
        boolean wasInactive;
        super.updateServerSide();
        if (!this.hasMaster()) {
            return;
        }
        boolean bl = wasInactive = this.workingTime == 0;
        if (this.workingTime < 20 && this.energyManager.consumeEnergyToDoWork()) {
            this.workingTime += this.energyManager.getEnergyPerWork() / 10;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
            if (component != null) {
                component.addTemperatureChange(this.climateControl.changePerTransfer, this.climateControl.boundaryDown, this.climateControl.boundaryUp);
            }
        }
        if (wasInactive && this.workingTime > 0 || !wasInactive && this.workingTime == 0) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (this.workingTime > 0) {
            return this.textureOn;
        }
        return this.textureOff;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        int workingTime = payload.shortPayload[0];
        if (this.workingTime != workingTime) {
            this.workingTime = workingTime;
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 1);
        payload.shortPayload[0] = (short)this.workingTime;
        return payload;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    public static class ClimateControl {
        final float changePerTransfer;
        final float boundaryUp;
        final float boundaryDown;

        public ClimateControl(float changePerTransfer, float boundaryDown, float boundaryUp) {
            this.changePerTransfer = changePerTransfer;
            this.boundaryDown = boundaryDown;
            this.boundaryUp = boundaryUp;
        }
    }
}

