/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.TileForestry;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAlveary
extends TileForestry
implements IAlvearyComponent {
    private final IStructureLogic structureLogic = new StructureLogicAlveary(this);
    private boolean isMaster;
    protected int masterX;
    protected int masterZ;
    protected int masterY = -99;
    protected final int componentBlockMeta;

    public TileAlveary(int componentBlockMeta) {
        this.componentBlockMeta = componentBlockMeta;
    }

    @Override
    public void initialize() {
        if (!ForestryBlock.alveary.isBlockEqual(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            Proxies.log.info("Updating alveary block at %s/%s/%s.", this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ForestryBlock.alveary.block(), this.componentBlockMeta, 2);
            this.func_145829_t();
            this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    @Override
    public void func_145845_h() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.field_145850_b.func_82737_E() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public int getIcon(int side, int metadata) {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        if (this.isMaster) {
            this.makeMaster();
        }
        super.func_145839_a(nbttagcompound);
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    protected void createInventory() {
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 2);
        payload.shortPayload[0] = (short)(this.isMaster() ? 1 : 0);
        payload.shortPayload[1] = (short)this.masterY;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (payload.shortPayload[0] > 0) {
            this.makeMaster();
        }
        this.masterY = payload.shortPayload[1];
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.getInternalInventory() instanceof FakeInventoryAdapter) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
        }
        this.isMaster = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster()) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_145851_c == this.field_145851_c && tile.field_145848_d == this.field_145848_d && tile.field_145849_e == this.field_145849_e;
    }

    @Override
    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_145851_c;
        this.masterY = tile.field_145848_d;
        this.masterZ = tile.field_145849_e;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    public final IInventoryAdapter getInventory() {
        return this.getStructureInventory();
    }

    @Override
    public IInventoryAdapter getStructureInventory() {
        return this.getInternalInventory();
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void registerBeeListener(IBeeListener event) {
    }

    @Override
    public void removeBeeListener(IBeeListener event) {
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        return res;
    }
}

