/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BeeStatsSaveHelper
implements IStatsSaveHelper {
    @Override
    public String getUnlocalizedSaveStatsString() {
        return "for.chat.command.forestry.bee.save.stats";
    }

    @Override
    public void addExtraInfo(Collection<String> statistics, IBreedingTracker breedingTracker) {
        IApiaristTracker tracker = (IApiaristTracker)breedingTracker;
        String discoveredLine = StatCollector.func_74838_a((String)"for.chat.command.forestry.stats.save.key.discovered") + ":";
        statistics.add(discoveredLine);
        statistics.add(StringUtil.line(discoveredLine.length()));
        String queen = StatCollector.func_74838_a((String)"for.bees.grammar.queen.type");
        String princess = StatCollector.func_74838_a((String)"for.bees.grammar.princess.type");
        String drone = StatCollector.func_74838_a((String)"for.bees.grammar.drone.type");
        statistics.add(queen + ":\t\t" + tracker.getQueenCount());
        statistics.add(princess + ":\t" + tracker.getPrincessCount());
        statistics.add(drone + ":\t\t" + tracker.getDroneCount());
        statistics.add("");
    }

    @Override
    public Collection<IAlleleSpecies> getSpecies() {
        ArrayList<IAlleleSpecies> species = new ArrayList<IAlleleSpecies>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            species.add((IAlleleBeeSpecies)allele);
        }
        return species;
    }

    @Override
    public String getFileSuffix() {
        return "bees";
    }

    @Override
    public IBreedingTracker getBreedingTracker(World world, GameProfile gameProfile) {
        return PluginApiculture.beeInterface.getBreedingTracker(world, gameProfile);
    }
}

