/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderGourd
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150393_bb || block == Blocks.field_150394_bc;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet<EnumPlantType> types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != Blocks.field_150393_bb && block != Blocks.field_150394_bc) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta > 6) {
            return false;
        }
        meta = meta < 6 ? (meta += 2) : 7;
        world.func_72921_c(x, y, z, meta, 2);
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.gourd");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Blocks.field_150464_aj, 1, 8)};
    }
}

