/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BeekeepingLogic
implements IBeekeepingLogic {
    private static final int MAX_POLLINATION_ATTEMPTS = 20;
    private final IBeeHousing housing;
    private int breedingTime;
    private final int totalBreedingTime = 100;
    private int queenWorkCycleThrottle;
    private IEffectData[] effectData = new IEffectData[2];
    private IBee queen;
    private IIndividual pollen;
    private int attemptedPollinations = 0;
    private final Stack<ItemStack> spawn = new Stack();

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.breedingTime = nbttagcompound.func_74762_e("BreedingTime");
        this.queenWorkCycleThrottle = nbttagcompound.func_74762_e("Throttle");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Offspring", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            this.spawn.add(ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("BreedingTime", this.breedingTime);
        nbttagcompound.func_74768_a("Throttle", this.queenWorkCycleThrottle);
        Stack<ItemStack> spawnCopy = new Stack<ItemStack>();
        spawnCopy.addAll(this.spawn);
        NBTTagList nbttaglist = new NBTTagList();
        while (!spawnCopy.isEmpty()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemStack)spawnCopy.pop()).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Offspring", (NBTBase)nbttaglist);
    }

    @Override
    public int getBreedingTime() {
        return this.breedingTime;
    }

    @Override
    public int getTotalBreedingTime() {
        return this.totalBreedingTime;
    }

    @Override
    public IBee getQueen() {
        return this.queen;
    }

    @Override
    public IBeeHousing getHousing() {
        return this.housing;
    }

    @Override
    public IEffectData[] getEffectData() {
        return this.effectData;
    }

    @Override
    public void update() {
        this.queen = null;
        if (!this.addPendingProducts()) {
            return;
        }
        if (this.tryBreedingPrincess() || !this.hasHealthyQueen()) {
            return;
        }
        if (!this.queenCanWork()) {
            return;
        }
        this.queenWorkTick();
    }

    private void queenWorkTick() {
        this.effectData = this.queen.doEffect(this.effectData, this.housing);
        ++this.queenWorkCycleThrottle;
        if (this.queenWorkCycleThrottle >= PluginApiculture.ticksPerBeeWorkCycle) {
            this.queenWorkCycleThrottle = 0;
            if (this.queen.hasFlower(this.housing)) {
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
                this.doQueenWorkCycle();
            } else {
                this.housing.setErrorState(EnumErrorCode.NOFLOWER.ordinal());
            }
        }
    }

    private void doQueenWorkCycle() {
        this.doProduction();
        this.queen.plantFlowerRandom(this.housing);
        this.doPollination();
        this.queen.age(this.housing.getWorld(), this.housing.getLifespanModifier(this.queen.getGenome(), this.queen.getMate(), 0.0f));
        this.updateQueenItemNBT();
    }

    private void doProduction() {
        ItemStack[] products = this.queen.produceStacks(this.housing);
        this.housing.wearOutEquipment(1);
        for (ItemStack stack : products) {
            this.housing.addProduct(stack, false);
        }
    }

    private void doPollination() {
        if (this.pollen == null) {
            this.pollen = this.queen.retrievePollen(this.housing);
            this.attemptedPollinations = 0;
            if (this.pollen != null && this.housing.onPollenRetrieved(this.queen, this.pollen, false)) {
                this.pollen = null;
            }
        }
        if (this.pollen != null) {
            ++this.attemptedPollinations;
            if (this.queen.pollinateRandom(this.housing, this.pollen) || this.attemptedPollinations >= 20) {
                this.pollen = null;
            }
        }
    }

    private void updateQueenItemNBT() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.queen.writeToNBT(nbttagcompound);
        this.housing.getQueen().func_77982_d(nbttagcompound);
    }

    private boolean addPendingProducts() {
        Enum housingErrorState = null;
        while (!this.spawn.isEmpty()) {
            ItemStack next = this.spawn.peek();
            if (this.housing.addProduct(next, true)) {
                this.spawn.pop();
                housingErrorState = EnumErrorCode.OK;
                continue;
            }
            housingErrorState = EnumErrorCode.NOSPACE;
            break;
        }
        if (housingErrorState != null) {
            try {
                this.housing.setErrorState((IErrorState)((Object)housingErrorState));
            }
            catch (Error e) {
                this.housing.setErrorState(housingErrorState.ordinal());
            }
        }
        return housingErrorState != EnumErrorCode.NOSPACE;
    }

    private boolean hasHealthyQueen() {
        boolean hasQueen = true;
        EnumErrorCode housingErrorState = null;
        if (this.housing.getQueen() == null || !ForestryItem.beeQueenGE.isItemEqual(this.housing.getQueen())) {
            housingErrorState = EnumErrorCode.NOQUEEN;
            hasQueen = false;
        } else {
            IBee queen = PluginApiculture.beeInterface.getMember(this.housing.getQueen());
            if (!queen.isAlive()) {
                this.killQueen(queen);
                housingErrorState = EnumErrorCode.OK;
                hasQueen = false;
            } else {
                this.queen = queen;
            }
        }
        if (housingErrorState != null) {
            try {
                this.housing.setErrorState(housingErrorState);
            }
            catch (Error e) {
                this.housing.setErrorState(housingErrorState.ordinal());
            }
        }
        return hasQueen;
    }

    private boolean tryBreedingPrincess() {
        boolean isBreedingPrincess = false;
        if (ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            if (ForestryItem.beeDroneGE.isItemEqual(this.housing.getDrone())) {
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            } else {
                this.housing.setErrorState(EnumErrorCode.NODRONE.ordinal());
            }
            this.tickBreed();
            isBreedingPrincess = true;
        }
        return isBreedingPrincess;
    }

    private boolean queenCanWork() {
        try {
            boolean canWork = true;
            IErrorState state = this.queen.canWork(this.housing);
            if (state != EnumErrorCode.OK) {
                this.housing.setErrorState(state);
                canWork = false;
            } else if (this.housing.getErrorState() != EnumErrorCode.NOFLOWER) {
                this.housing.setErrorState(EnumErrorCode.OK);
            }
            return canWork;
        }
        catch (Error e) {
            Proxies.log.logErrorAPI("Forestry", e, IBee.class);
            return this.queenCanWorkDeprecated();
        }
    }

    private boolean queenCanWorkDeprecated() {
        boolean canWork = true;
        EnumErrorCode state = EnumErrorCode.values()[this.queen.isWorking(this.housing)];
        if (state != EnumErrorCode.OK) {
            this.housing.setErrorState(state.ordinal());
            canWork = false;
        } else if (this.housing.getErrorOrdinal() != EnumErrorCode.NOFLOWER.ordinal()) {
            this.housing.setErrorState(EnumErrorCode.OK.ordinal());
        }
        return canWork;
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < 100) {
            ++this.breedingTime;
        }
        if (this.breedingTime < 100) {
            return;
        }
        if (!ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            return;
        }
        IBee princess = PluginApiculture.beeInterface.getMember(this.housing.getQueen());
        IBee drone = PluginApiculture.beeInterface.getMember(this.housing.getDrone());
        princess.mate(drone);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        princess.writeToNBT(nbttagcompound);
        ItemStack queen = ForestryItem.beeQueenGE.getItemStack();
        queen.func_77982_d(nbttagcompound);
        this.housing.setQueen(queen);
        this.housing.onQueenChange(this.housing.getQueen());
        PluginApiculture.beeInterface.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName()).registerQueen(princess);
        --this.housing.getDrone().field_77994_a;
        if (this.housing.getDrone().field_77994_a <= 0) {
            this.housing.setDrone(null);
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.housing.getDrone() == null || this.housing.getQueen() == null) {
            return false;
        }
        if (!ForestryItem.beeDroneGE.isItemEqual(this.housing.getDrone()) || !ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            return false;
        }
        return this.housing.canBreed();
    }

    private void killQueen(IBee queen) {
        if (queen.canSpawn()) {
            this.spawnOffspring(queen);
            this.housing.getQueen().field_77994_a = 0;
            this.housing.setQueen(null);
        } else {
            Proxies.log.warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            ItemStack convert = ForestryItem.beePrincessGE.getItemStack();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            convert.func_77982_d(nbttagcompound);
            this.spawn.add(convert);
            this.housing.setQueen(null);
        }
        this.housing.onQueenChange(this.housing.getQueen());
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = PluginApiculture.beeInterface.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName());
        this.housing.onQueenDeath(this.getQueen());
        IBee heiress = queen.spawnPrincess(this.housing);
        if (heiress != null) {
            ItemStack princess = PluginApiculture.beeInterface.getMemberStack(heiress, EnumBeeType.PRINCESS.ordinal());
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        for (IBee larva : larvae = queen.spawnDrones(this.housing)) {
            ItemStack drone = PluginApiculture.beeInterface.getMemberStack(larva, EnumBeeType.DRONE.ordinal());
            breedingTracker.registerDrone(larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (this.housing.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
        this.housing.onPostQueenDeath(this.getQueen());
    }
}

