/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IEmpowerableItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.item.tool.ItemToolAdv;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public abstract class ItemToolRF
extends ItemToolAdv
implements IEmpowerableItem,
IEnergyContainerItem,
IEqualityOverrideItem {
    IIcon activeIcon;
    IIcon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;
    int damage = 0;

    public ItemToolRF(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial);
        this.setNoRepair();
    }

    public ItemToolRF(Item.ToolMaterial toolMaterial, int n) {
        super(0.0f, toolMaterial, n);
        this.setNoRepair();
    }

    protected float getEfficiency(ItemStack itemStack) {
        if (this.isEmpowered(itemStack) && this.getEnergyStored(itemStack) >= this.energyPerUseCharged) {
            return ((ItemTool)this).field_77864_a * 1.5f;
        }
        return ((ItemTool)this).field_77864_a;
    }

    protected int useEnergy(ItemStack itemStack, boolean bl) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return this.extractEnergy(itemStack, this.isEmpowered(itemStack) ? this.energyPerUseCharged * (5 - n) / 5 : this.energyPerUse * (5 - n) / 5, bl);
    }

    protected int getEnergyPerUse(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return (this.isEmpowered(itemStack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - n) / 5;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int n) {
        if (this.getEnergyStored(itemStack) < this.energyPerUse) {
            return 1.0f;
        }
        return super.getDigSpeed(itemStack, block, n);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityLivingBase, EntityLivingBase entityLivingBase2) {
        float f;
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase2;
        float f2 = f = entityLivingBase2.field_70143_R > 0.0f && !entityLivingBase2.field_70122_E && !entityLivingBase2.func_70617_f_() && !entityLivingBase2.func_70090_H() && !entityLivingBase2.func_70644_a(Potion.field_76440_q) && entityLivingBase2.field_70154_o == null ? 1.5f : 1.0f;
        if (entityPlayer.field_71075_bZ.field_75098_d || this.extractEnergy(itemStack, this.energyPerUse, false) == this.energyPerUse) {
            int n = this.isEmpowered(itemStack) ? 2 : 1;
            float f3 = (float)this.damage + EnchantmentHelper.func_77512_a((EntityLivingBase)entityLivingBase2, (EntityLivingBase)entityLivingBase);
            entityLivingBase.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)entityPlayer), (float)n);
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), ((float)n + f3) * f);
        } else {
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), 1.0f * f);
        }
        return true;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(itemStack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        if (this.isEmpowered(itemStack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOn") + "\u00a7r");
        }
        if (this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack)) {
            list.add("");
            list.add("\u00a79+" + this.damage + " " + StringHelper.localize((String)"info.cofh.damageAttack") + "\u00a7r");
            list.add("\u00a7a+" + (this.isEmpowered(itemStack) ? 2 : 1) + " " + StringHelper.localize((String)"info.cofh.damageFlux") + "\u00a7r");
        }
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return 1 + this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return itemStack.func_77960_j() != Short.MAX_VALUE;
    }

    public Multimap func_111205_h() {
        return HashMultimap.create();
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        return this.isEmpowered(itemStack) ? this.activeIcon : (this.getEnergyStored(itemStack) <= 0 ? this.drainedIcon : ((Item)this).field_77791_bV);
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        ((Item)this).field_77791_bV = iIconRegister.func_94245_a(this.func_111208_A());
        this.activeIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Active");
        this.drainedIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Drained");
    }

    public boolean isEmpowered(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Empowered");
    }

    public boolean setEmpoweredState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Empowered", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public void onStateChange(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "ambient.weather.thunder", 0.4f, 1.0f);
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0) {
                this.setEmpoweredState(itemStack, false);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack itemStack, ItemStack itemStack2) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = itemStack2.field_77990_d;
        if (nBTTagCompound == nBTTagCompound2) {
            return true;
        }
        if (nBTTagCompound == null | nBTTagCompound2 == null) {
            return false;
        }
        nBTTagCompound = (NBTTagCompound)nBTTagCompound.func_74737_b();
        nBTTagCompound2 = (NBTTagCompound)nBTTagCompound2.func_74737_b();
        nBTTagCompound.func_82580_o("Energy");
        nBTTagCompound2.func_82580_o("Energy");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }
}

