/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IEmpowerableItem;
import cofh.core.entity.EntityCoFHFishHook;
import cofh.core.item.tool.ItemFishingRodAdv;
import cofh.core.util.CoreUtils;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemFishingRodRF
extends ItemFishingRodAdv
implements IEmpowerableItem,
IEnergyContainerItem {
    IIcon[] activeIcons = new IIcon[2];
    IIcon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;

    public ItemFishingRodRF(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.toolMaterial = toolMaterial;
        this.func_77656_e(toolMaterial.func_77997_a());
        this.setNoRepair();
    }

    protected void useEnergy(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        this.extractEnergy(itemStack, this.isEmpowered(itemStack) ? this.energyPerUseCharged * (5 - n) / 5 : this.energyPerUse * (5 - n) / 5, false);
    }

    protected int getEnergyPerUse(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return (this.isEmpowered(itemStack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - n) / 5;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d && this.getEnergyStored(itemStack) < this.getEnergyPerUse(itemStack)) {
            return itemStack;
        }
        if (entityPlayer.field_71104_cf != null) {
            int n = entityPlayer.field_71104_cf.func_146034_e();
            this.useEnergy(itemStack);
        } else {
            world.func_72956_a((Entity)entityPlayer, "random.bow", 0.5f, 0.4f / (Item.field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (ServerHelper.isServerWorld((World)world)) {
                world.func_72838_d((Entity)new EntityCoFHFishHook(world, entityPlayer));
            }
        }
        entityPlayer.func_71038_i();
        return itemStack;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(itemStack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        if (this.isEmpowered(itemStack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOn") + "\u00a7r");
        }
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return 1 + this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return itemStack.func_77960_j() != Short.MAX_VALUE;
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        EntityPlayer entityPlayer = CoreUtils.getClientPlayer();
        if (entityPlayer.field_71071_by.func_70448_g() == itemStack && entityPlayer.field_71104_cf != null) {
            return this.isEmpowered(itemStack) ? this.activeIcons[1] : this.normalIcons[1];
        }
        return this.isEmpowered(itemStack) ? this.activeIcons[0] : (this.getEnergyStored(itemStack) <= 0 ? this.drainedIcon : this.normalIcons[0]);
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        super.func_94581_a(iIconRegister);
        this.drainedIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Drained");
        this.activeIcons[0] = iIconRegister.func_94245_a(this.func_111208_A() + "_Uncast_Active");
        this.activeIcons[1] = iIconRegister.func_94245_a(this.func_111208_A() + "_Cast_Active");
    }

    public boolean isEmpowered(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Empowered");
    }

    public boolean setEmpoweredState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Empowered", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public void onStateChange(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "ambient.weather.thunder", 0.4f, 1.0f);
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0) {
                this.setEmpoweredState(itemStack, false);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }
}

