/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import openperipheral.ApiImplementation;
import openperipheral.api.IEntityMetaBuilder;
import openperipheral.api.IEntityMetaProvider;
import openperipheral.meta.MetaProvidersRegistry;

@ApiImplementation
public class EntityMetadataBuilder
implements IEntityMetaBuilder {
    @Override
    public Map<String, Object> getEntityMetadata(Entity entity, Vec3 relativePos) {
        return EntityMetadataBuilder.fillProperties(entity, relativePos);
    }

    private static Map<String, Object> fillProperties(Entity entity, Vec3 relativePos) {
        HashMap map = Maps.newHashMap();
        EntityMetadataBuilder.fillBasicProperties(map, entity, relativePos);
        EntityMetadataBuilder.fillCustomProperties(map, entity, relativePos);
        return map;
    }

    private static void fillCustomProperties(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        Iterable<IEntityMetaProvider<?>> providers = MetaProvidersRegistry.ENITITES.getProviders(entity.getClass());
        for (IEntityMetaProvider<?> provider : providers) {
            Object converted = provider.getMeta(entity, relativePos);
            if (converted == null) continue;
            String key = provider.getKey();
            map.put(key, converted);
        }
    }

    private static void fillBasicProperties(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        EntityMetadataBuilder.addPositionInfo(map, entity, relativePos);
        map.put("name", entity.func_70005_c_());
        map.put("id", entity.func_145782_y());
        map.put("uuid", entity.func_110124_au());
        if (entity.field_70153_n != null) {
            map.put("riddenBy", EntityMetadataBuilder.fillProperties(entity.field_70153_n, relativePos));
        }
        if (entity.field_70154_o != null) {
            map.put("ridingEntity", entity.field_70154_o.func_145782_y());
        }
    }

    private static void addPositionInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        Map<String, Object> position = relativePos != null ? EntityMetadataBuilder.addRelativePos(entity, relativePos) : EntityMetadataBuilder.addAbsolutePos(entity);
        map.put("position", position);
    }

    private static Map<String, Object> addAbsolutePos(Entity entity) {
        HashMap position = Maps.newHashMap();
        position.put("x", entity.field_70165_t);
        position.put("y", entity.field_70163_u);
        position.put("z", entity.field_70161_v);
        return position;
    }

    private static Map<String, Object> addRelativePos(Entity entity, Vec3 relativePos) {
        HashMap position = Maps.newHashMap();
        position.put("x", entity.field_70165_t - relativePos.field_72450_a);
        position.put("y", entity.field_70163_u - relativePos.field_72448_b);
        position.put("z", entity.field_70161_v - relativePos.field_72449_c);
        return position;
    }

    @Override
    public void register(IEntityMetaProvider<?> provider) {
        MetaProvidersRegistry.ENITITES.addProvider(provider);
    }
}

