/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.InventoryUtils;
import openperipheral.api.Arg;
import openperipheral.api.Asynchronous;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaArgType;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.Optionals;

@Asynchronous
public class AdapterInventory
implements IPeripheralAdapter {
    private static final int ANY_SLOT = -1;

    @Override
    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    @Override
    public String getSourceId() {
        return "inventory";
    }

    @LuaCallable(returnTypes={LuaReturnType.STRING}, description="Get the name of this inventory")
    public String getInventoryName(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_145825_b() : null;
    }

    @LuaCallable(returnTypes={LuaReturnType.NUMBER}, description="Get the size of this inventory")
    public int getInventorySize(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    @LuaCallable(description="Condense and tidy the stacks in an inventory")
    public void condenseItems(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack sta = inventory.func_70301_a(i);
            if (sta != null) {
                stacks.add(sta.func_77946_l());
            }
            inventory.func_70299_a(i, null);
        }
        for (ItemStack stack : stacks) {
            ItemDistribution.insertItemIntoInventory((IInventory)inventory, (ItemStack)stack, (ForgeDirection)ForgeDirection.UNKNOWN, (int)-1);
        }
        target.func_70296_d();
    }

    @LuaCallable(description="Swap two slots in the inventory")
    public void swapStacks(IInventory target, @Arg(name="from", description="The first slot") int fromSlot, @Arg(name="to", description="The other slot") int intoSlot, @Optionals @Arg(name="fromDirection") ForgeDirection fromDirection, @Arg(name="fromDirection") ForgeDirection toDirection) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid target!");
        if (inventory instanceof ISidedInventory) {
            InventoryUtils.swapStacks((ISidedInventory)((ISidedInventory)inventory), (int)(fromSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)fromDirection, (Object)ForgeDirection.UNKNOWN)), (int)(intoSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)toDirection, (Object)ForgeDirection.UNKNOWN)));
        } else {
            InventoryUtils.swapStacks((IInventory)inventory, (int)(fromSlot - 1), (int)(intoSlot - 1));
        }
        inventory.func_70296_d();
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get details of an item in a particular slot")
    public ItemStack getStackInSlot(IInventory target, @Arg(name="slotNumber", description="The slot number, from 1 to the max amount of slots") int slot) {
        IInventory invent = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)invent.func_70302_i_(), (String)"slot id");
        return invent.func_70301_a(slot);
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get a table with all the items of the chest")
    public ItemStack[] getAllStacks(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ItemStack[] allStacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            allStacks[i] = inventory.func_70301_a(i);
        }
        return allStacks;
    }

    @LuaCallable(description="Destroy a stack")
    public void destroyStack(IInventory target, @Arg(name="slotNumber", description="The slot number, from 1 to the max amount of slots") int slot) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)inventory.func_70302_i_(), (String)"slot id");
        inventory.func_70299_a(slot, null);
        inventory.func_70296_d();
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get full stack information from stub one {id=..., [qty=...], [dmg=...]}")
    public ItemStack expandStack(@Arg(name="stack", type=LuaArgType.TABLE) ItemStack itemStack) {
        return itemStack;
    }
}

