/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.thaumcraft;

import java.util.List;
import java.util.Map;
import openmods.reflection.FieldAccess;
import openmods.reflection.ReflectionHelper;
import openperipheral.api.Asynchronous;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.integration.thaumcraft.ConverterAspectList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;

@Asynchronous
public class AdapterJar
implements IPeripheralAdapter {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"thaumcraft.common.tiles.TileJarFillable");
    private final FieldAccess<Aspect> ASPECT_FILTER = FieldAccess.create(this.CLASS, (String[])new String[]{"aspectFilter"});

    @Override
    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    @Override
    public String getSourceId() {
        return "thaumcraft_jar";
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the aspect filtered by this block block")
    public String getAspectFilter(Object target) {
        Aspect aspect = (Aspect)this.ASPECT_FILTER.get(target);
        return aspect != null ? aspect.getName() : "";
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the Aspects stored in the block")
    public List<Map<String, Object>> getAspects(IAspectContainer container) {
        Aspect filter;
        List<Map<String, Object>> result = ConverterAspectList.aspectsToMap(container.getAspects());
        if (result.isEmpty() && (filter = (Aspect)this.ASPECT_FILTER.get((Object)container)) != null) {
            ConverterAspectList.appendAspectEntry(result, filter, 0);
        }
        return result;
    }
}

