/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openmods.Log;
import openperipheral.api.helpers.ItemStackMetaProviderSimple;

public class BookMetaProvider
extends ItemStackMetaProviderSimple<Item> {
    @Override
    public String getKey() {
        return "myst_book";
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        NBTTagCompound tag;
        String unlocalizedName = target.func_77658_a();
        boolean isLinkbook = "item.myst.linkbook".equals(unlocalizedName);
        boolean isAgebook = "item.myst.agebook".equals(unlocalizedName);
        if ((isLinkbook || isAgebook) && (tag = stack.func_77978_p()) != null) {
            HashMap result = Maps.newHashMap();
            Log.info((String)"%s", (Object[])new Object[]{tag});
            result.put("type", isLinkbook ? "link" : (isAgebook ? "age" : "unknown"));
            result.put("destination", tag.func_74779_i("agename"));
            result.put("dimension", tag.func_74762_e("Dimension"));
            BookMetaProvider.addLinkingBookFlags(result, tag);
            BookMetaProvider.addCoordinates(result, tag);
            return result;
        }
        return null;
    }

    private static void addCoordinates(Map<String, Object> map, NBTTagCompound tag) {
        HashMap pos = Maps.newHashMap();
        map.put("spawn", pos);
        pos.put(1, tag.func_74762_e("SpawnX"));
        pos.put(2, tag.func_74762_e("SpawnY"));
        pos.put(3, tag.func_74762_e("SpawnZ"));
        map.put("spawnYaw", Float.valueOf(tag.func_74760_g("SpawnYaw")));
    }

    private static void addLinkingBookFlags(Map<String, Object> map, NBTTagCompound tag) {
        HashMap flags = Maps.newHashMap();
        if (tag.func_74764_b("Flags")) {
            Set tags = tag.func_74775_l("Flags").func_150296_c();
            for (String s : tags) {
                flags.put(s, Boolean.TRUE);
            }
        }
        map.put("flags", flags);
    }
}

