/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.forestry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.Synchronizable;

@Synchronizable
public class AdapterBeeHousing
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IBeeHousing.class;
    }

    @Override
    public String getSourceId() {
        return "forestry_bees";
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Can the bees breed?")
    public boolean canBreed(IBeeHousing beeHousing) {
        return beeHousing.canBreed();
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the drone")
    public IIndividual getDrone(IBeeHousing beeHousing) {
        ItemStack drone = beeHousing.getDrone();
        if (drone != null) {
            return AlleleManager.alleleRegistry.getIndividual(drone);
        }
        return null;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the queen")
    public IIndividual getQueen(IBeeHousing beeHousing) {
        ItemStack queen = beeHousing.getQueen();
        if (queen != null) {
            return AlleleManager.alleleRegistry.getIndividual(queen);
        }
        return null;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the full breeding list thingy. Experimental!")
    public Map<Integer, Map<String, Object>> getBeeBreedingData(IBeeHousing housing) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        int j = 1;
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele2;
            HashMap<String, Object> mutationMap = new HashMap<String, Object>();
            IAllele allele1 = mutation.getAllele0();
            if (allele1 != null) {
                mutationMap.put("allele1", allele1.getName());
            }
            if ((allele2 = mutation.getAllele1()) != null) {
                mutationMap.put("allele2", allele2.getName());
            }
            mutationMap.put("chance", Float.valueOf(mutation.getBaseChance()));
            mutationMap.put("specialConditions", mutation.getSpecialConditions().toArray());
            IAllele[] template = mutation.getTemplate();
            if (template != null && template.length > 0) {
                mutationMap.put("result", template[0].getName());
            }
            result.put(j++, mutationMap);
        }
        return result;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get all known bees mutations")
    public List<Map<String, String>> listAllSpecies(IBeeHousing housing) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele;
            IAllele[] template = mutation.getTemplate();
            if (template == null || template.length <= 0 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
            result.add(AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele));
        }
        return result;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the parents for a particular mutation")
    public List<Map<String, Object>> getBeeParents(IBeeHousing housing, @Arg(name="childType", description="The type of bee you want the parents for") String childType) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        childType = childType.toLowerCase();
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele;
            IAllele[] template = mutation.getTemplate();
            if (template == null || template.length < 1 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
            IAlleleSpecies species = (IAlleleSpecies)allele;
            String uid = species.getUID().toLowerCase();
            String localizedName = species.getName().toLowerCase();
            if (!localizedName.equals(childType) && !uid.equals(childType)) continue;
            Map<String, Object> parentMap = AdapterBeeHousing.serializeMutation(mutation);
            result.add(parentMap);
        }
        return result;
    }

    private static Map<String, String> serializeSpecies(IAlleleSpecies species) {
        HashMap result = Maps.newHashMap();
        result.put("name", species.getName());
        result.put("uid", species.getUID());
        return result;
    }

    private static Map<String, Object> serializeMutation(IMutation mutation) {
        IAllele allele2;
        HashMap parentMap = Maps.newHashMap();
        IAllele allele1 = mutation.getAllele0();
        if (allele1 instanceof IAlleleSpecies) {
            parentMap.put("allele1", AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele1));
        }
        if ((allele2 = mutation.getAllele1()) instanceof IAlleleSpecies) {
            parentMap.put("allele2", AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele2));
        }
        parentMap.put("chance", Float.valueOf(mutation.getBaseChance()));
        parentMap.put("specialConditions", mutation.getSpecialConditions());
        return parentMap;
    }
}

