/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.computercraft;

import com.google.common.collect.Maps;
import dan200.computercraft.api.media.IMedia;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openperipheral.api.helpers.ItemStackMetaProviderSimple;

public class MediaMetaProvider
extends ItemStackMetaProviderSimple<Item> {
    private final Class<?> API_CLASS = ReflectionHelper.getClass((String)"dan200.computercraft.ComputerCraft");
    private final MethodAccess.Function1<IMedia, ItemStack> GET_MEDIA = MethodAccess.create(IMedia.class, this.API_CLASS, ItemStack.class, (String[])new String[]{"getMedia"});

    @Override
    public String getKey() {
        return "disk";
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        if (target instanceof IMedia) {
            return MediaMetaProvider.addDiskInfo(stack, (IMedia)target);
        }
        IMedia media = (IMedia)this.GET_MEDIA.call(null, (Object)stack);
        if (media != null) {
            return MediaMetaProvider.addDiskInfo(stack, media);
        }
        return null;
    }

    private static Map<String, Object> addDiskInfo(ItemStack stack, IMedia item) {
        String record;
        HashMap diskInfo = Maps.newHashMap();
        String label = item.getLabel(stack);
        if (label != null) {
            diskInfo.put("label", label);
        }
        if ((record = item.getAudioRecordName(stack)) != null) {
            diskInfo.put("record", record);
        }
        return diskInfo;
    }
}

