/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.buildcraft;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import com.google.common.base.Preconditions;
import net.minecraftforge.common.util.ForgeDirection;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;

public class AdapterPipe
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IPipeTile.class;
    }

    @Override
    public String getSourceId() {
        return "buildcraft_pipe";
    }

    private static IPipe getPipe(IPipeTile target) {
        IPipe pipe = target.getPipe();
        Preconditions.checkNotNull((Object)pipe, (Object)"Invalid pipe");
        return pipe;
    }

    @LuaCallable(description="Checks if this pipe has a gate", returnTypes={LuaReturnType.BOOLEAN})
    public boolean hasGate(IPipeTile target, @Arg(name="side") ForgeDirection side) {
        return AdapterPipe.getPipe(target).hasGate(side);
    }

    @LuaCallable(description="Checks if a wire is on the pipe", returnTypes={LuaReturnType.BOOLEAN})
    public boolean isWired(IPipeTile target, @Arg(name="wire", description="The colour of the wire") PipeWire wire) {
        return AdapterPipe.getPipe(target).isWired(wire);
    }

    @LuaCallable(description="Checks if a wire on the pipe is active", returnTypes={LuaReturnType.BOOLEAN})
    public boolean isWireActive(IPipeTile target, @Arg(name="wire", description="The colour of the wire") PipeWire wire) {
        return AdapterPipe.getPipe(target).isWireActive(wire);
    }

    @LuaCallable(description="Get type of pipe", returnTypes={LuaReturnType.STRING})
    public IPipeTile.PipeType getPipeType(IPipeTile target) {
        return target.getPipeType();
    }

    @LuaCallable(description="Get type of pipe", returnTypes={LuaReturnType.BOOLEAN})
    public boolean isPipeConnected(IPipeTile target, @Arg(name="side") ForgeDirection side) {
        return target.isPipeConnected(side);
    }
}

