/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import openmods.integration.IIntegrationModule;
import openmods.integration.Integration;
import openperipheral.integration.buildcraft.ModuleBuildCraftFacades;
import openperipheral.integration.buildcraft.ModuleBuildCraftPower;
import openperipheral.integration.buildcraft.ModuleBuildCraftTile;
import openperipheral.integration.buildcraft.ModuleBuildCraftTransport;
import openperipheral.integration.cofh.energy.ModuleCofhEnergy;
import openperipheral.integration.cofh.inventory.ModuleCofhInventory;
import openperipheral.integration.cofh.item.ModuleCofhItem;
import openperipheral.integration.cofh.tileentity.ModuleCofhTileEntity;
import openperipheral.integration.cofh.transport.ModuleCofhTransport;
import openperipheral.integration.computercraft.ModuleComputerCraft;
import openperipheral.integration.enderstorage.ModuleEnderStorage;
import openperipheral.integration.forestry.ModuleForestry;
import openperipheral.integration.ic2.ModuleIC2;
import openperipheral.integration.ic2.ModuleIC2Api;
import openperipheral.integration.minefactoryreloaded.ModuleMinefactoryReloaded;
import openperipheral.integration.mystcraft.ModuleMystcraft;
import openperipheral.integration.railcraft.ModuleRailcraft;
import openperipheral.integration.railcraft.ModuleRailcraftCarts;
import openperipheral.integration.railcraft.ModuleRailcraftFuel;
import openperipheral.integration.thaumcraft.ModuleThaumcraft;
import openperipheral.integration.thaumcraft.ModuleThaumcraftApi;
import openperipheral.integration.tmechworks.ModuleTMechworks;
import openperipheral.integration.vanilla.ModuleVanilla;

@Mod(modid="OpenPeripheralIntegration", name="OpenPeripheralIntegration", version="0.1.0", guiFactory="openperipheral.integration.ConfigGuiFactory", dependencies="required-after:OpenMods@[0.6];required-after:ComputerCraft@[1.64,];required-after:OpenPeripheralCore")
public class OpenPeripheralIntegration {
    public static final String MOD_ID = "OpenPeripheralIntegration";
    public static final String CATEGORY_MODULES = "modules";
    @Mod.Instance(value="OpenPeripheralIntegration")
    public static OpenPeripheralIntegration instance;
    Configuration config;

    private static boolean checkConfig(Configuration config, String value) {
        Property property = config.get(CATEGORY_MODULES, value, true);
        property.setRequiresMcRestart(true);
        return property.getBoolean();
    }

    public Configuration config() {
        return this.config;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.config = new Configuration(evt.getSuggestedConfigurationFile());
        if (this.config.hasCategory("integration")) {
            ConfigCategory integration = this.config.getCategory("integration");
            this.config.removeCategory(integration);
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "vanilla")) {
            Integration.addModule((IIntegrationModule)new ModuleVanilla());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-energy")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhEnergy());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-inventory")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhInventory());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-item")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhItem());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-tileentity")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhTileEntity());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-transport")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhTransport());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-power")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftPower());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-transport")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftTransport());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-tilenentity")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftTile());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-facades")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftFacades());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "ic2-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleIC2());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "ic2-api")) {
            Integration.addModule((IIntegrationModule)new ModuleIC2Api());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-api-carts")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraftCarts());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-api-fuel")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraftFuel());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-api")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraftApi());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "computercraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleComputerCraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "enderstorage-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleEnderStorage());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "forestry-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleForestry());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "mystcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleMystcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "tmechworks-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleTMechworks());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "mfr-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleMinefactoryReloaded());
        }
        FMLCommonHandler.instance().bus().register((Object)new ConfigChangeListener());
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public class ConfigChangeListener {
        @SubscribeEvent
        public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (OpenPeripheralIntegration.MOD_ID.equals(evt.modID)) {
                OpenPeripheralIntegration.this.config.save();
            }
        }
    }
}

