/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter;

import java.util.Arrays;
import openperipheral.api.ITypeConverter;
import openperipheral.api.ITypeConvertersRegistry;

public class ConverterEnum
implements ITypeConverter {
    @Override
    public Object fromLua(ITypeConvertersRegistry registry, Object obj, Class<?> expected) {
        if (expected.isEnum() && obj instanceof String) {
            Object[] constants;
            String value = (String)obj;
            for (Object obj2 : constants = expected.getEnumConstants()) {
                if (!obj2.toString().equalsIgnoreCase(value)) continue;
                return obj2;
            }
            throw new IllegalArgumentException(String.format("'%s' is not valid enum value, must be %s", value, Arrays.toString(constants)));
        }
        return null;
    }

    @Override
    public Object toLua(ITypeConvertersRegistry registry, Object obj) {
        if (obj instanceof Enum) {
            return obj.toString();
        }
        return null;
    }
}

