/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.ticketmachine;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IHasGui;
import openmods.api.IIconProvider;
import openmods.api.IInventoryCallback;
import openmods.api.IPlaceAwareTile;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;
import openperipheral.addons.ticketmachine.BlockTicketMachine;
import openperipheral.addons.ticketmachine.ContainerTicketMachine;
import openperipheral.addons.ticketmachine.GuiTicketMachine;
import openperipheral.api.Arg;
import openperipheral.api.Asynchronous;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.Optionals;
import openperipheral.api.PeripheralTypeId;

@PeripheralTypeId(value="openperipheral_ticketmachine")
public class TileEntityTicketMachine
extends SyncedTileEntity
implements IPlaceAwareTile,
IHasGui,
IIconProvider,
IInventoryProvider,
IInventoryCallback {
    private static final int SLOT_PAPER = 0;
    private static final int SLOT_INK = 1;
    private static final int SLOT_OUTPUT = 2;
    private final Item ticketItem;
    @IncludeInterface(value=ISidedInventory.class)
    protected GenericInventory inventory = new CustomInventory().addCallback(this);
    protected SyncableBoolean hasTicket;
    protected SyncableString owner;

    public IInventory getInventory() {
        return this.inventory;
    }

    protected void createSyncedFields() {
        this.hasTicket = new SyncableBoolean();
        this.owner = new SyncableString();
    }

    public TileEntityTicketMachine() {
        ItemStack ticketStack = GameRegistry.findItemStack((String)"Railcraft", (String)"routing.ticket", (int)1);
        this.ticketItem = ticketStack != null ? ticketStack.func_77973_b() : null;
        this.syncMap.addUpdateListener(this.createRenderUpdateListener());
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Create a new ticket to the specified destination")
    public boolean createTicket(@Arg(name="destination", description="The destination for the ticket") String destination, @Arg(name="amount") @Optionals Integer amount) {
        if (amount == null) {
            amount = 1;
        } else {
            Preconditions.checkArgument((amount > 0 && amount <= 64 ? 1 : 0) != 0, (Object)"Amount must be between 1 and 64");
        }
        ItemStack paperStack = this.inventory.func_70301_a(0);
        Preconditions.checkState((this.inventory.func_94041_b(0, paperStack) && paperStack.field_77994_a >= amount ? 1 : 0) != 0, (Object)"Not enough paper");
        ItemStack inkStack = this.inventory.func_70301_a(1);
        Preconditions.checkState((this.inventory.func_94041_b(1, inkStack) && inkStack.field_77994_a >= amount ? 1 : 0) != 0, (Object)"Not enough ink");
        ItemStack output = this.inventory.func_70301_a(2);
        ItemStack newTicket = new ItemStack(this.ticketItem);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)newTicket);
        tag.func_74778_a("owner", this.owner.getValue());
        tag.func_74778_a("dest", destination);
        if (output == null) {
            this.inventory.func_70299_a(2, newTicket);
        } else if (ItemStack.func_77970_a((ItemStack)output, (ItemStack)newTicket) && output.func_77969_a(newTicket) && output.field_77994_a + amount <= output.func_77976_d()) {
            output.field_77994_a += amount.intValue();
        } else {
            throw new IllegalArgumentException("No place in output slot");
        }
        this.inventory.func_70298_a(0, amount.intValue());
        this.inventory.func_70298_a(1, amount.intValue());
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openperipheraladdons:ticketmachine", 0.3f, 0.6f);
        this.sync();
        return true;
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.STRING}, description="Returns owner of this machine")
    public String getOwner() {
        return this.owner.getValue();
    }

    public void onInventoryChanged(IInventory inventory, int slotNumber) {
        boolean nowHasTicket;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = nowHasTicket = inventory.func_70301_a(2) != null;
        if (nowHasTicket != this.hasTicket.getValue()) {
            this.hasTicket.set(nowHasTicket);
        }
        this.markUpdated();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.owner.setValue(player.func_70005_c_());
    }

    public IIcon getIcon(ForgeDirection rotatedDir) {
        if (rotatedDir == ForgeDirection.SOUTH) {
            return this.hasTicket.getValue() != false ? BlockTicketMachine.iconFrontTicket : BlockTicketMachine.iconFrontEmpty;
        }
        return null;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerTicketMachine((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiTicketMachine(new ContainerTicketMachine((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private static class CustomInventory
    extends GenericInventory
    implements ISidedInventory {
        private CustomInventory() {
            super("ticketmachine", false, 3);
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (itemstack == null) {
                return false;
            }
            switch (i) {
                case 0: {
                    return itemstack.func_77973_b() == Items.field_151121_aF;
                }
                case 1: {
                    Set color = ColorUtils.stackToColor((ItemStack)itemstack);
                    return color != null && color.contains(ColorUtils.ColorMeta.BLACK);
                }
            }
            return false;
        }

        public int[] func_94128_d(int side) {
            return new int[]{1, 0, 2};
        }

        public boolean func_102007_a(int slot, ItemStack stack, int side) {
            return this.func_94041_b(slot, stack);
        }

        public boolean func_102008_b(int slot, ItemStack stack, int side) {
            return slot == 2;
        }
    }
}

