/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import openmods.tileentity.OpenTileEntity;
import openperipheral.addons.glasses.GlassesRenderingUtils;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalManagerServer;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.api.ApiAccess;
import openperipheral.api.Arg;
import openperipheral.api.Asynchronous;
import openperipheral.api.IAdapterFactory;
import openperipheral.api.IAttachable;
import openperipheral.api.Include;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.PeripheralTypeId;

@PeripheralTypeId(value="openperipheral_bridge")
public class TileEntityGlassesBridge
extends OpenTileEntity
implements IAttachable {
    private static final String EVENT_CHAT_MESSAGE = "chat_command";
    private static final String EVENT_PLAYER_JOIN = "registered_player_join";
    private final Map<UUID, PlayerInfo> knownPlayersByUUID = Maps.newHashMap();
    private final Map<String, PlayerInfo> knownPlayersByName = Maps.newHashMap();
    private final Set<EntityPlayerMP> newPlayers = Sets.newSetFromMap(new WeakHashMap());
    private List<IComputerAccess> computers = Lists.newArrayList();
    public SurfaceServer globalSurface = new SurfaceServer();
    private long guid = TerminalUtils.generateGuid();

    public void registerTerminal(EntityPlayerMP player) {
        if (!this.knownPlayersByUUID.containsKey(player.func_146103_bH().getId())) {
            this.newPlayers.add(player);
        }
    }

    public void onChatCommand(String command, String username) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(EVENT_CHAT_MESSAGE, new Object[]{command, username, this.guid, computer.getAttachmentName()});
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        TerminalManagerServer.instance.registerBridge(this.guid, this);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K || this.globalSurface == null) {
            return;
        }
        Iterator<PlayerInfo> it = this.knownPlayersByUUID.values().iterator();
        while (it.hasNext()) {
            PlayerInfo info = it.next();
            EntityPlayerMP player = (EntityPlayerMP)info.player.get();
            if (this.isPlayerValid(player)) continue;
            this.sendCleanPackets(player);
            it.remove();
        }
        for (EntityPlayerMP newPlayer : this.newPlayers) {
            if (!this.isPlayerValid(newPlayer)) continue;
            PlayerInfo playerInfo = new PlayerInfo(this, newPlayer);
            GameProfile gameProfile = newPlayer.func_146103_bH();
            this.knownPlayersByUUID.put(gameProfile.getId(), playerInfo);
            this.knownPlayersByName.put(gameProfile.getName(), playerInfo);
            this.onPlayerJoin(gameProfile);
        }
    }

    private void sendCleanPackets(EntityPlayerMP player) {
        new TerminalEvent.TerminalClearEvent(this.guid, false).sendToPlayer((EntityPlayer)player);
        new TerminalEvent.TerminalClearEvent(this.guid, true).sendToPlayer((EntityPlayer)player);
    }

    private boolean isPlayerValid(EntityPlayerMP player) {
        if (player == null) {
            return false;
        }
        if (player.field_70128_L && !TileEntityGlassesBridge.isPlayerLogged(player)) {
            return false;
        }
        Long guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)player);
        return guid != null && guid == this.guid;
    }

    private static boolean isPlayerLogged(EntityPlayerMP player) {
        GameProfile gameProfile = player.func_146103_bH();
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP p : players) {
            if (!p.func_146103_bH().equals((Object)gameProfile)) continue;
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74772_a("guid", this.guid);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        Long guid = TerminalUtils.extractGuid(tag);
        if (guid != null) {
            this.guid = guid;
        }
    }

    public void onPlayerJoin(GameProfile player) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(EVENT_PLAYER_JOIN, new Object[]{player.getName(), player.getId()});
        }
    }

    @Override
    public void addComputer(IComputerAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
    }

    @Override
    public void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public SurfaceServer getSurface(String username) {
        if ("GLOBAL".equals(username)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByName.get(username);
        return info != null ? info.surface : null;
    }

    public SurfaceServer getSurface(UUID uuid) {
        if (TerminalUtils.GLOBAL_SURFACE_UUID.equals(uuid)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByUUID.get(uuid);
        return info != null ? info.surface : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaCallable(description="Send updates to client. Without it changes won't be visible", name="sync")
    public void syncContents() {
        TerminalEvent.TerminalDataEvent globalChange = null;
        boolean sendGlobalUpdate = this.globalSurface.hasUpdates();
        SurfaceServer surfaceServer = this.globalSurface;
        synchronized (surfaceServer) {
            for (PlayerInfo info : this.knownPlayersByUUID.values()) {
                SurfaceServer privateSurface;
                EntityPlayerMP player = (EntityPlayerMP)info.player.get();
                if (!this.isPlayerValid(player)) continue;
                if (sendGlobalUpdate) {
                    if (globalChange == null) {
                        globalChange = TerminalManagerServer.createUpdateDataEvent(this.globalSurface, this.guid, false);
                    }
                    globalChange.sendToPlayer((EntityPlayer)player);
                }
                if ((privateSurface = info.surface) == null) continue;
                SurfaceServer surfaceServer2 = privateSurface;
                synchronized (surfaceServer2) {
                    if (privateSurface.hasUpdates()) {
                        TerminalEvent.TerminalDataEvent privateData = TerminalManagerServer.createUpdateDataEvent(privateSurface, this.guid, true);
                        privateData.sendToPlayer((EntityPlayer)player);
                    }
                }
            }
            TerminalEvent.TerminalDataEvent globalFull = null;
            for (EntityPlayerMP newPlayer : this.newPlayers) {
                if (!this.isPlayerValid(newPlayer)) continue;
                if (globalFull == null) {
                    globalFull = TerminalManagerServer.createFullDataEvent(this.globalSurface, this.guid, false);
                }
                globalFull.sendToPlayer((EntityPlayer)newPlayer);
            }
        }
        this.newPlayers.clear();
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get the names of all the users linked up to this bridge")
    public List<GameProfile> getUsers() {
        ArrayList result = Lists.newArrayList();
        for (PlayerInfo info : this.knownPlayersByName.values()) {
            result.add(info.profile);
        }
        return result;
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.STRING}, name="getGuid", description="Get the Guid of this bridge")
    public String getGuidString() {
        return TerminalUtils.formatTerminalId(this.guid);
    }

    public long getGuid() {
        return this.guid;
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.NUMBER}, description="Get the display width of some text")
    public int getStringWidth(@Arg(name="text", description="The text you want to measure") String text) {
        return GlassesRenderingUtils.getStringWidth(text);
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public ILuaObject getSurfaceByName(@Arg(name="username", description="The username of the user to get the draw surface for") String username) {
        SurfaceServer playerSurface = this.getSurface(username);
        Preconditions.checkNotNull((Object)((Object)playerSurface), (Object)"Invalid player");
        return ApiAccess.getApi(IAdapterFactory.class).wrapObject((Object)playerSurface);
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public ILuaObject getSurfaceByUUID(@Arg(name="uuid", description="The uuid of the user to get the draw surface for") String username) {
        UUID uuid = UUID.fromString(username);
        SurfaceServer playerSurface = this.getSurface(uuid);
        Preconditions.checkNotNull((Object)((Object)playerSurface), (Object)"Invalid player");
        return ApiAccess.getApi(IAdapterFactory.class).wrapObject((Object)playerSurface);
    }

    @Include
    public SurfaceServer getGlobalSurface() {
        return this.globalSurface;
    }

    private static class PlayerInfo {
        public final GameProfile profile;
        public final WeakReference<EntityPlayerMP> player;
        public SurfaceServer surface;

        public PlayerInfo(TileEntityGlassesBridge parent, EntityPlayerMP player) {
            this.player = new WeakReference<EntityPlayerMP>(player);
            this.profile = player.func_146103_bH();
            this.surface = new SurfaceServer();
        }
    }
}

