/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.ServerChatEvent;
import openmods.Log;
import openperipheral.addons.api.TerminalRegisterEvent;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.TileEntityGlassesBridge;

public class TerminalManagerServer {
    public static final TerminalManagerServer instance = new TerminalManagerServer();
    private final Map<Long, TileEntityGlassesBridge> listeners = new MapMaker().weakValues().makeMap();

    private TerminalManagerServer() {
    }

    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        TileEntityGlassesBridge listener;
        EntityPlayerMP player = event.player;
        if (!event.message.startsWith("$$")) {
            return;
        }
        Long guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)player);
        if (guid != null && (listener = this.listeners.get(guid)) != null) {
            listener.onChatCommand(event.message.substring(2).trim(), event.username);
        }
        event.setCanceled(true);
    }

    private SurfaceServer getSurface(long terminalId, UUID playerId) {
        TileEntityGlassesBridge bridge = this.listeners.get(terminalId);
        if (bridge == null) {
            return null;
        }
        return bridge.getSurface(playerId);
    }

    @SubscribeEvent
    public void onResetRequest(TerminalEvent.TerminalResetEvent evt) {
        EntityPlayer player = evt.sender;
        UUID playerUUID = evt.isPrivate ? player.func_146103_bH().getId() : TerminalUtils.GLOBAL_SURFACE_UUID;
        SurfaceServer surface = this.getSurface(evt.terminalId, playerUUID);
        if (surface != null) {
            TerminalEvent.TerminalDataEvent resetEvt = TerminalManagerServer.createFullDataEvent(surface, evt.terminalId, evt.isPrivate);
            evt.reply(resetEvt);
        } else {
            Log.warn((String)"Player %s requested invalid surface (%s,%b)", (Object[])new Object[]{player, TerminalUtils.formatTerminalId(evt.terminalId), evt.isPrivate});
        }
    }

    public static TerminalEvent.TerminalDataEvent createFullDataEvent(SurfaceServer surface, long terminalId, boolean isPrivate) {
        TerminalEvent.TerminalDataEvent result = new TerminalEvent.TerminalDataEvent(terminalId, isPrivate);
        surface.appendFullCommands((List)result.commands);
        return result;
    }

    public static TerminalEvent.TerminalDataEvent createUpdateDataEvent(SurfaceServer surface, long terminalId, boolean isPrivate) {
        TerminalEvent.TerminalDataEvent result = new TerminalEvent.TerminalDataEvent(terminalId, isPrivate);
        surface.appendUpdateCommands((List)result.commands);
        return result;
    }

    @SubscribeEvent
    public void onTerminalRegister(TerminalRegisterEvent evt) {
        TileEntityGlassesBridge listener = this.listeners.get(evt.terminalId);
        if (listener != null) {
            listener.registerTerminal(evt.player);
        }
    }

    public void registerBridge(long terminalId, TileEntityGlassesBridge bridge) {
        this.listeners.put(terminalId, bridge);
    }
}

