/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openperipheral.addons.glasses.GlassesRenderingUtils;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.api.CallbackProperty;
import openperipheral.api.IPropertyCallback;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import org.lwjgl.opengl.GL11;

public abstract class Drawable
implements IPropertyCallback {
    SurfaceServer.DrawableWrapper wrapper;
    @CallbackProperty
    public short x;
    @CallbackProperty
    public short y;
    @CallbackProperty
    public short z;

    protected Drawable() {
    }

    protected Drawable(short x, short y) {
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.x, (double)this.y, (double)this.z);
        this.drawContents(partialTicks);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawContents(float var1);

    protected abstract Type getType();

    public int getTypeId() {
        return this.getType().ordinal();
    }

    public static Drawable createFromTypeId(int containerId, int typeId) {
        Type type = Type.TYPES[typeId];
        return type.create();
    }

    @LuaCallable(returnTypes={LuaReturnType.STRING}, name="getType", description="Get object type")
    public String getTypeName() {
        return this.getType().name().toLowerCase();
    }

    @LuaCallable
    public void delete() {
        Preconditions.checkNotNull((Object)this.wrapper, (Object)"Object is already deleted");
        this.wrapper.delete();
        this.wrapper = null;
    }

    @LuaCallable(returnTypes={LuaReturnType.NUMBER}, name="getId")
    public int getId() {
        Preconditions.checkNotNull((Object)this.wrapper, (Object)"Object is deleted");
        return this.wrapper.containerId + 1;
    }

    @Override
    public void setField(Field field, Object value) {
        Preconditions.checkNotNull((Object)this.wrapper, (Object)"Object is deleted");
        this.wrapper.setField(field, value);
    }

    @Override
    public Object getField(Field field) {
        Preconditions.checkNotNull((Object)this.wrapper, (Object)"Object is deleted");
        return this.wrapper.getField(field);
    }

    public static class Text
    extends Drawable {
        @CallbackProperty
        public String text;
        @CallbackProperty
        public int color;
        @CallbackProperty
        public double alpha = 1.0;
        @CallbackProperty
        public float scale = 1.0f;

        private Text() {
        }

        public Text(short x, short y, String text, int color) {
            super(x, y);
            this.text = text;
            this.color = color;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            fontRenderer.func_78276_b(this.text, 0, 0, (int)(this.alpha * 255.0) << 24 | this.color);
        }

        @Override
        public Type getType() {
            return Type.TEXT;
        }
    }

    public static class LiquidIcon
    extends Drawable {
        @CallbackProperty
        public short width;
        @CallbackProperty
        public short height;
        @CallbackProperty
        public String fluid;
        @CallbackProperty
        public float alpha = 1.0f;

        private LiquidIcon() {
        }

        public LiquidIcon(short x, short y, short width, short height, String fluid) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.fluid = fluid;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            Fluid drawLiquid = FluidRegistry.getFluid((String)this.fluid);
            if (drawLiquid == null) {
                return;
            }
            IIcon fluidIcon = drawLiquid.getFlowingIcon();
            if (fluidIcon == null) {
                return;
            }
            int iconWidth = fluidIcon.func_94211_a();
            int iconHeight = fluidIcon.func_94216_b();
            if (iconWidth <= 0 || iconHeight <= 0) {
                return;
            }
            TextureManager render = FMLClientHandler.instance().getClient().field_71446_o;
            render.func_110577_a(TextureMap.field_110575_b);
            float xIterations = (float)this.width / (float)iconWidth;
            float yIterations = (float)this.height / (float)iconHeight;
            for (float xIteration = 0.0f; xIteration < xIterations; xIteration += 1.0f) {
                for (float yIteration = 0.0f; yIteration < yIterations; yIteration += 1.0f) {
                    float xDrawSize = Math.min(xIterations - xIteration, 1.0f);
                    float yDrawSize = Math.min(yIterations - yIteration, 1.0f);
                    GlassesRenderingUtils.drawTexturedQuad(xIteration * (float)iconWidth, yIteration * (float)iconHeight, fluidIcon, xDrawSize * (float)iconWidth, yDrawSize * (float)iconHeight, xDrawSize, yDrawSize, this.alpha);
                }
            }
        }

        @Override
        public Type getType() {
            return Type.LIQUID;
        }
    }

    public static class ItemIcon
    extends Drawable {
        @SideOnly(value=Side.CLIENT)
        private RenderItem renderItem;
        @CallbackProperty
        public float scale = 1.0f;
        @CallbackProperty
        public String itemId;
        @CallbackProperty
        public int meta;

        private ItemIcon() {
        }

        public ItemIcon(short x, short y, String itemId, int meta) {
            super(x, y);
            this.itemId = itemId;
            this.meta = meta;
        }

        @SideOnly(value=Side.CLIENT)
        private RenderItem getRenderItem() {
            if (this.renderItem == null) {
                this.renderItem = new RenderItem();
            }
            return this.renderItem;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            if (Strings.isNullOrEmpty((String)this.itemId)) {
                return;
            }
            String[] itemSplit = this.itemId.split(":");
            if (itemSplit.length != 2) {
                return;
            }
            Item item = GameRegistry.findItem((String)itemSplit[0], (String)itemSplit[1]);
            if (item == null) {
                return;
            }
            ItemStack drawStack = new ItemStack(item, 1, this.meta);
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.getRenderItem().func_82406_b(null, Minecraft.func_71410_x().func_110434_K(), drawStack, 0, 0);
            GL11.glDisable((int)2896);
        }

        @Override
        public Type getType() {
            return Type.ITEM;
        }
    }

    public static class GradientBox
    extends Drawable {
        @CallbackProperty
        public short width;
        @CallbackProperty
        public short height;
        @CallbackProperty
        public int color1;
        @CallbackProperty
        public float opacity1;
        @CallbackProperty
        public int color2;
        @CallbackProperty
        public float opacity2;
        @CallbackProperty
        public int gradient;

        private GradientBox() {
        }

        public GradientBox(short x, short y, short width, short height, int color1, float opacity1, int color2, float opacity2, int gradient) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.color1 = color1;
            this.opacity1 = opacity1;
            if (gradient == 0) {
                this.color2 = color1;
                this.opacity2 = opacity1;
            } else {
                this.color2 = color2;
                this.opacity2 = opacity2;
            }
            this.gradient = gradient;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78384_a(this.color1, (int)(this.opacity1 * 255.0f));
            if (this.gradient == 1) {
                tessellator.func_78377_a(0.0, (double)this.height, 0.0);
                tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
            } else {
                tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
                tessellator.func_78377_a((double)this.width, 0.0, 0.0);
            }
            tessellator.func_78384_a(this.color2, (int)(this.opacity2 * 255.0f));
            if (this.gradient == 1) {
                tessellator.func_78377_a((double)this.width, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 0.0);
            } else {
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, (double)this.height, 0.0);
            }
            tessellator.func_78381_a();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
        }

        @Override
        public Type getType() {
            return Type.GRADIENT;
        }
    }

    public static class SolidBox
    extends Drawable {
        @CallbackProperty
        public short width;
        @CallbackProperty
        public short height;
        @CallbackProperty
        public int color;
        @CallbackProperty
        public float opacity;

        private SolidBox() {
        }

        public SolidBox(short x, short y, short width, short height, int color, float opacity) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.color = color;
            this.opacity = opacity;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78384_a(this.color, (int)(this.opacity * 255.0f));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78377_a(0.0, (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.width, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
        }

        @Override
        public Type getType() {
            return Type.BOX;
        }
    }

    private static enum Type {
        GRADIENT{

            @Override
            public Drawable create() {
                return new GradientBox();
            }
        }
        ,
        BOX{

            @Override
            public Drawable create() {
                return new SolidBox();
            }
        }
        ,
        TEXT{

            @Override
            public Drawable create() {
                return new Text();
            }
        }
        ,
        LIQUID{

            @Override
            public Drawable create() {
                return new LiquidIcon();
            }
        }
        ,
        ITEM{

            @Override
            public Drawable create() {
                return new ItemIcon();
            }
        };

        public static final Type[] TYPES;

        public abstract Drawable create();

        static {
            TYPES = Type.values();
        }
    }
}

