/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import openmods.Log;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.PropertyListBuilder;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;
import openperipheral.api.PeripheralTypeId;

public class PeripheralInlineAdapterWrapper
extends PeripheralAdapterWrapper
implements PropertyListBuilder.IPropertyExecutorFactory<IPeripheralMethodExecutor> {
    private final String source;

    private static String getSourceId(Class<?> cls) {
        PeripheralTypeId id = cls.getAnnotation(PeripheralTypeId.class);
        if (id != null) {
            return id.value();
        }
        Log.trace((String)"Inline adapter %s has no PeripheralTypeId annotation", (Object[])new Object[]{cls});
        return cls.getName().toLowerCase();
    }

    public PeripheralInlineAdapterWrapper(Class<?> targetClass) {
        this(targetClass, PeripheralInlineAdapterWrapper.getSourceId(targetClass));
    }

    private PeripheralInlineAdapterWrapper(Class<?> targetClass, String source) {
        super(targetClass, targetClass, source);
        this.source = source;
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
        return new PeripheralAdapterWrapper.PeripheralMethodExecutor(method, strategy){

            @Override
            protected MethodDeclaration.CallWrap createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
                return this.method.createWrapper(target).setJavaArg("computer", computer).setJavaArg("context", context).setLuaArgs(luaArgs);
            }
        };
    }

    @Override
    protected void configureJavaArguments(MethodDeclaration decl) {
        decl.declareJavaArgType("computer", IComputerAccess.class);
        decl.declareJavaArgType("context", ILuaContext.class);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[0]));
        return new IPeripheralMethodExecutor(){

            @Override
            public IDescriptable description() {
                return executor.description();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke(target, new Object[0]);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    @Override
    public IPeripheralMethodExecutor createExecutor(PropertyListBuilder.FieldContext context) {
        return new PeripheralPropertyExecutor(context);
    }

    @Override
    protected List<IPeripheralMethodExecutor> buildMethodList() {
        List<IPeripheralMethodExecutor> result = super.buildMethodList();
        PropertyListBuilder.buildPropertyList(this.targetClass, this.source, this, result);
        return result;
    }

    @Override
    public String describe() {
        return "internal periperal (source: " + this.adapterClass.toString() + ")";
    }

    @Override
    public boolean canUse(Class<?> cls) {
        return true;
    }

    private static class PeripheralPropertyExecutor
    extends PropertyListBuilder.PropertyExecutor
    implements IPeripheralMethodExecutor {
        protected PeripheralPropertyExecutor(PropertyListBuilder.FieldContext context) {
            super(context);
        }

        @Override
        public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) {
            return this.call(target, args);
        }
    }
}

