/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.concurrent.Callable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openmods.utils.WorldUtils;
import openmods.world.DelayedActionTickHandler;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.api.IWorldProvider;

public abstract class ExecutionStrategy {
    private static final String SYNC_EVENT = "op_tick_sync";
    private static int currentId;
    public static final Object[] DUMMY;
    public static final ExecutionStrategy ASYNCHRONOUS;
    private static final ExecutionStrategy ON_TICK_TILE_ENTITY;
    private static final ExecutionStrategy ON_TICK_WORLD_PROVIDER;
    private static final ExecutionStrategy ON_TICK_OTHER;

    public abstract Object[] execute(Object var1, IComputerAccess var2, ILuaContext var3, Callable<Object[]> var4) throws Exception;

    private static synchronized int getNextId() {
        return currentId++;
    }

    public boolean isAlwaysSafe() {
        return true;
    }

    public static Object[] wrap(Object ... args) {
        return args;
    }

    public static ExecutionStrategy createOnTickStrategy(Class<?> targetClass) {
        if (TileEntity.class.isAssignableFrom(targetClass)) {
            return ON_TICK_TILE_ENTITY;
        }
        if (IWorldProvider.class.isAssignableFrom(targetClass)) {
            return ON_TICK_WORLD_PROVIDER;
        }
        return ON_TICK_OTHER;
    }

    static {
        DUMMY = new Object[0];
        ASYNCHRONOUS = new ExecutionStrategy(){

            @Override
            public Object[] execute(Object target, IComputerAccess computer, ILuaContext context, Callable<Object[]> callable) throws Exception {
                try {
                    return callable.call();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (LuaException e) {
                    throw e;
                }
                catch (Exception t) {
                    throw new AdapterLogicException(t);
                }
            }
        };
        ON_TICK_TILE_ENTITY = new OnTick<TileEntity>(){

            @Override
            public World getWorld(TileEntity target) {
                return target.func_145831_w();
            }

            @Override
            public boolean isLoaded(TileEntity target) {
                return WorldUtils.isTileEntityValid((TileEntity)target);
            }
        };
        ON_TICK_WORLD_PROVIDER = new OnTick<IWorldProvider>(){

            @Override
            public World getWorld(IWorldProvider target) {
                return target.getWorld();
            }

            @Override
            public boolean isLoaded(IWorldProvider target) {
                return target.isValid();
            }
        };
        ON_TICK_OTHER = new OnTick<Object>(){

            @Override
            public World getWorld(Object target) {
                if (target instanceof TileEntity) {
                    return ((TileEntity)target).func_145831_w();
                }
                if (target instanceof IWorldProvider) {
                    return ((IWorldProvider)target).getWorld();
                }
                throw new UnsupportedOperationException(String.format("Methods of adapter for %s cannot be synchronous", target.getClass()));
            }

            @Override
            public boolean isAlwaysSafe() {
                return false;
            }

            @Override
            public boolean isLoaded(Object target) {
                if (target instanceof TileEntity) {
                    return WorldUtils.isTileEntityValid((TileEntity)((TileEntity)target));
                }
                if (target instanceof IWorldProvider) {
                    return ((IWorldProvider)target).isValid();
                }
                throw new UnsupportedOperationException(String.format("Methods of adapter for %s cannot be synchronous", target.getClass()));
            }
        };
    }

    private static abstract class OnTick<T>
    extends ExecutionStrategy {
        private OnTick() {
        }

        public abstract boolean isLoaded(T var1);

        public abstract World getWorld(T var1);

        @Override
        public Object[] execute(final Object target, IComputerAccess computer, ILuaContext context, final Callable<Object[]> callable) throws Exception {
            World world = this.getWorld(target);
            Preconditions.checkNotNull((Object)world, (Object)"Trying to execute OnTick method, but no available world");
            final Responder responder = new Responder(context, computer);
            DelayedActionTickHandler.INSTANCE.addTickCallback(world, new Runnable(){

                @Override
                public void run() {
                    boolean isStillLoaded = OnTick.this.isLoaded(target);
                    if (isStillLoaded) {
                        try {
                            responder.result = (Object[])callable.call();
                        }
                        catch (Throwable e) {
                            responder.error = e;
                        }
                        responder.signalEvent(true);
                    } else {
                        responder.result = DUMMY;
                        responder.signalEvent(false);
                    }
                }
            });
            responder.waitForEvent();
            if (responder.error != null) {
                throw new AdapterLogicException(responder.error);
            }
            return responder.result;
        }
    }

    private static class Responder {
        private final ILuaContext context;
        private final IComputerAccess access;
        private boolean nobodyLovesMe;
        private final int transactionId;
        public Throwable error;
        public Object[] result;

        private Responder(ILuaContext context, IComputerAccess access) {
            this.context = context;
            this.access = access;
            this.transactionId = ExecutionStrategy.getNextId();
        }

        public void waitForEvent() throws Exception {
            while (!this.nobodyLovesMe) {
                Object[] result;
                try {
                    result = this.context.pullEvent(ExecutionStrategy.SYNC_EVENT);
                }
                catch (Exception e) {
                    this.nobodyLovesMe = true;
                    throw e;
                }
                catch (Throwable t) {
                    this.nobodyLovesMe = true;
                    throw Throwables.propagate((Throwable)t);
                }
                int transactionId = ((Number)result[1]).intValue();
                if (transactionId != this.transactionId) continue;
                break;
            }
        }

        public void signalEvent(boolean log) {
            block5: {
                Preconditions.checkState((this.error != null || this.result != null ? 1 : 0) != 0, (Object)"Must set either 'error' or 'result' before firing event");
                if (this.nobodyLovesMe) {
                    if (log) {
                        Log.warn((String)"Ignoring signal for transaction %s. (sob)", (Object[])new Object[]{this.transactionId});
                    }
                } else {
                    try {
                        this.access.queueEvent(ExecutionStrategy.SYNC_EVENT, ExecutionStrategy.wrap(this.transactionId));
                    }
                    catch (Exception e) {
                        if (!log) break block5;
                        Log.warn((Throwable)e, (String)"Failed to signal response to transaction '%d'", (Object[])new Object[]{this.transactionId});
                    }
                }
            }
        }
    }
}

