/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.Arrays;
import openmods.Log;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.WrappedEntityBase;
import openperipheral.adapter.object.IObjectMethodExecutor;
import org.apache.logging.log4j.Level;

public class LuaObjectWrapper {
    public static ILuaObject wrap(AdapterManager<IObjectMethodExecutor> manager, Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Can't wrap null");
        MethodMap<IObjectMethodExecutor> methods = manager.getAdaptedClass(target.getClass());
        return methods.isEmpty() ? null : new WrappedLuaObject(methods, target);
    }

    private static class WrappedLuaObject
    extends WrappedEntityBase<IObjectMethodExecutor>
    implements ILuaObject {
        private final Object target;

        private WrappedLuaObject(MethodMap<IObjectMethodExecutor> methods, Object target) {
            super(methods);
            this.target = target;
        }

        @Override
        public String[] getMethodNames() {
            return super.getMethodNames();
        }

        public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            IObjectMethodExecutor executor = (IObjectMethodExecutor)this.getMethod(method);
            Preconditions.checkNotNull((Object)executor, (String)"Invalid method index: %d", (Object[])new Object[]{method});
            try {
                return executor.execute(context, this.target, arguments);
            }
            catch (LuaException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                String methodName = this.getMethodName(method);
                Log.log((Level)Level.DEBUG, (Throwable)t.getCause(), (String)"Internal error during method %s(%d) execution on object %s, args: %s", (Object[])new Object[]{methodName, method, this.target.getClass(), Arrays.toString(arguments)});
                throw new AdapterLogicException(t).rethrow();
            }
        }
    }
}

