/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import openmods.Log;
import openmods.reflection.TypeUtils;
import openmods.utils.AnnotationMap;
import openperipheral.TypeConversionRegistry;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.method.Argument;
import openperipheral.adapter.method.ArgumentBuilder;
import openperipheral.api.Alias;
import openperipheral.api.Arg;
import openperipheral.api.Env;
import openperipheral.api.IMultiReturn;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.Optionals;
import org.apache.logging.log4j.Level;

public class MethodDeclaration
implements IDescriptable {
    private final List<String> names;
    private final String source;
    private final Method method;
    private final String description;
    private final LuaReturnType[] returnTypes;
    private final boolean validateReturn;
    private final BiMap<String, Integer> namedArgs = HashBiMap.create();
    private final Set<String> allowedNames = Sets.newHashSet();
    private final List<Class<?>> javaArgs;
    private final List<Argument> luaArgs;

    private static List<String> getNames(Method method, LuaCallable meta) {
        ImmutableList.Builder names = ImmutableList.builder();
        String mainName = meta.name();
        if ("[none set]".equals(mainName)) {
            names.add((Object)method.getName());
        } else {
            names.add((Object)mainName);
        }
        Alias alias = method.getAnnotation(Alias.class);
        if (alias != null) {
            names.add((Object[])alias.value());
        }
        return names.build();
    }

    public MethodDeclaration(Method method, LuaCallable meta, String source) {
        this.method = method;
        this.source = source;
        this.names = MethodDeclaration.getNames(method, meta);
        this.description = meta.description();
        this.returnTypes = meta.returnTypes();
        this.validateReturn = meta.validateReturn();
        if (this.validateReturn) {
            this.validateResultCount();
        }
        Class<?>[] methodArgs = method.getParameterTypes();
        boolean isVarArg = method.isVarArgs();
        ImmutableList.Builder luaArgs = ImmutableList.builder();
        ImmutableList.Builder javaArgs = ImmutableList.builder();
        ArgParseState state = ArgParseState.JAVA_REQUIRED;
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        for (int argIndex = 0; argIndex < methodArgs.length; ++argIndex) {
            try {
                Class<?> argType = methodArgs[argIndex];
                AnnotationMap argAnnotations = new AnnotationMap(argsAnnotations[argIndex]);
                boolean optionalStart = argAnnotations.get(Optionals.class) != null;
                Env envArg = (Env)argAnnotations.get(Env.class);
                Arg luaArg = (Arg)argAnnotations.get(Arg.class);
                Preconditions.checkState((envArg == null || luaArg == null ? 1 : 0) != 0, (Object)"@Arg and @Env are mutually exclusive");
                if (luaArg != null) {
                    if (state != ArgParseState.LUA_OPTIONAL) {
                        state = ArgParseState.LUA_REQUIRED;
                    }
                    if (optionalStart) {
                        Preconditions.checkState((state != ArgParseState.JAVA_OPTIONAL ? 1 : 0) != 0, (Object)"@Optional used more than once");
                        state = ArgParseState.LUA_OPTIONAL;
                    }
                    boolean isLastArg = argIndex == methodArgs.length - 1;
                    ArgumentBuilder builder = new ArgumentBuilder();
                    builder.setVararg(isLastArg && isVarArg);
                    builder.setOptional(state == ArgParseState.LUA_OPTIONAL);
                    builder.setNullable(luaArg.isNullable());
                    Argument arg = builder.build(luaArg.name(), luaArg.description(), luaArg.type(), argType, argIndex);
                    luaArgs.add((Object)arg);
                    continue;
                }
                Preconditions.checkState((state == ArgParseState.JAVA_OPTIONAL || state == ArgParseState.JAVA_REQUIRED ? 1 : 0) != 0, (Object)"Unannotated arg in Lua part (perhaps missing @Arg annotation?)");
                Preconditions.checkState((!optionalStart ? 1 : 0) != 0, (Object)"@Optionals does not work for java arguments");
                if (envArg != null) {
                    Preconditions.checkState((state == ArgParseState.JAVA_OPTIONAL || state == ArgParseState.JAVA_REQUIRED ? 1 : 0) != 0, (Object)"@Env annotation used in Lua part of arguments");
                    this.namedArgs.put((Object)envArg.value(), (Object)argIndex);
                    state = ArgParseState.JAVA_OPTIONAL;
                } else {
                    Preconditions.checkState((state == ArgParseState.JAVA_REQUIRED ? 1 : 0) != 0, (Object)"Unnamed arguments must be declared before named ones");
                }
                javaArgs.add(argType);
                continue;
            }
            catch (Throwable t) {
                throw new ArgumentDefinitionException(argIndex, t);
            }
        }
        this.luaArgs = luaArgs.build();
        this.javaArgs = javaArgs.build();
    }

    private void validateResultCount() {
        Class<?> javaReturn = this.method.getReturnType();
        int returnLength = this.returnTypes.length;
        for (LuaReturnType t : this.returnTypes) {
            Preconditions.checkArgument((t != LuaReturnType.VOID ? 1 : 0) != 0, (String)"Method '%s' declares Void as return type. Use empty list instead.", (Object[])new Object[]{this.method});
        }
        if (javaReturn == Void.TYPE) {
            Preconditions.checkArgument((returnLength == 0 ? 1 : 0) != 0, (String)"Method '%s' returns nothing, but declares at least one Lua result", (Object[])new Object[]{this.method});
        }
        if (returnLength == 0) {
            Preconditions.checkArgument((javaReturn == Void.TYPE ? 1 : 0) != 0, (String)"Method '%s' returns '%s', but declares no Lua results", (Object[])new Object[]{this.method, javaReturn});
        }
        if (returnLength > 1) {
            Preconditions.checkArgument((javaReturn == IMultiReturn.class ? 1 : 0) != 0, (String)"Method '%s' declared more than one Lua result, but returns single '%s' instead of '%s'", (Object[])new Object[]{this.method, javaReturn, IMultiReturn.class});
        }
    }

    private Object[] validateResult(Object ... result) {
        int i;
        for (i = 0; i < result.length; ++i) {
            result[i] = TypeConversionRegistry.INSTANCE.toLua(result[i]);
        }
        if (this.validateReturn) {
            if (this.returnTypes.length == 0) {
                Preconditions.checkArgument((result.length == 1 && result[0] == null ? 1 : 0) != 0, (Object)"Returning value from null method");
            } else {
                Preconditions.checkArgument((result.length == this.returnTypes.length ? 1 : 0) != 0, (String)"Returning invalid number of values from method %s, expected %s, got %s", (Object[])new Object[]{this.method, this.returnTypes.length, result.length});
                for (i = 0; i < result.length; ++i) {
                    LuaReturnType expected = this.returnTypes[i];
                    Class<?> expectedType = expected.getJavaType();
                    Object got = result[i];
                    Preconditions.checkArgument((got == null || expectedType.isInstance(got) || TypeUtils.compareTypes(expectedType, got.getClass()) ? 1 : 0) != 0, (String)"Invalid type of return value %s: expected %s, got %s", (Object[])new Object[]{i, expected, got});
                }
            }
        }
        return result;
    }

    public CallWrap createWrapper(Object target) {
        return new CallWrap(target);
    }

    public void setDefaultArgName(int index, String name) {
        if (index >= this.javaArgs.size()) {
            return;
        }
        if (this.namedArgs.containsValue((Object)index)) {
            return;
        }
        Integer prev = (Integer)this.namedArgs.put((Object)name, (Object)index);
        Preconditions.checkArgument((prev == null || prev == index ? 1 : 0) != 0, (String)"Trying to replace '%s' mapping from  %s, got %s", (Object[])new Object[]{name, prev, index});
    }

    public void declareJavaArgType(String name, Class<?> cls) {
        this.allowedNames.add(name);
        Integer index = (Integer)this.namedArgs.get((Object)name);
        if (index != null) {
            Class<?> expected = this.javaArgs.get(index);
            Preconditions.checkArgument((boolean)expected.isAssignableFrom(cls), (String)"Invalid argument type in method %s, was %s, got %s", (Object[])new Object[]{this.method, expected, cls});
        }
    }

    public void validate() {
        Sets.SetView unknown = Sets.difference((Set)this.namedArgs.keySet(), this.allowedNames);
        Preconditions.checkState((boolean)unknown.isEmpty(), (String)"Unknown named arg(s) %s in method '%s'. Allowed args: %s", (Object[])new Object[]{unknown, this.method, this.allowedNames});
        HashSet needed = Sets.newHashSet();
        for (int i = 0; i < this.javaArgs.size(); ++i) {
            needed.add(i);
        }
        HashSet named = Sets.newHashSet((Iterable)this.namedArgs.values());
        Sets.SetView missing = Sets.difference((Set)needed, (Set)named);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Arguments %s from method %s are not named", (Object[])new Object[]{missing, this.method});
        Sets.SetView extra = Sets.difference((Set)named, (Set)needed);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Lua arguments %s from method %s are named", (Object[])new Object[]{extra, this.method});
    }

    @Override
    public Map<String, Object> describe() {
        HashMap result = Maps.newHashMap();
        result.put("description", this.description);
        result.put("source", this.source);
        ArrayList returns = Lists.newArrayList();
        for (LuaReturnType t : this.returnTypes) {
            returns.add(t.toString());
        }
        result.put("returnTypes", returns);
        ArrayList args = Lists.newArrayList();
        for (Argument arg : this.luaArgs) {
            args.add(arg.describe());
        }
        result.put("args", args);
        return result;
    }

    @Override
    public String signature() {
        return "(" + Joiner.on((String)",").join(this.luaArgs) + ")";
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    public Class<?>[] getLuaArgTypes() {
        Class[] result = new Class[this.luaArgs.size()];
        int index = 0;
        for (Argument arg : this.luaArgs) {
            result[index++] = arg.javaType;
        }
        return result;
    }

    @Override
    public String source() {
        return this.source;
    }

    public class CallWrap
    implements Callable<Object[]> {
        private final Object[] args;
        private final Set<Integer> isSet;
        private final Object target;

        public CallWrap(Object target) {
            this.args = new Object[MethodDeclaration.this.javaArgs.size() + MethodDeclaration.this.luaArgs.size()];
            this.isSet = Sets.newHashSet();
            this.target = target;
        }

        private CallWrap setArg(int position, Object value) {
            boolean newlyAdded = this.isSet.add(position);
            Preconditions.checkState((boolean)newlyAdded, (String)"Trying to set already defined argument %s in method %s", (Object[])new Object[]{position, MethodDeclaration.this.method});
            this.args[position] = value;
            return this;
        }

        public CallWrap setJavaArg(String name, Object value) {
            Integer position = (Integer)MethodDeclaration.this.namedArgs.get((Object)name);
            if (position != null) {
                this.setArg(position, value);
            }
            return this;
        }

        public CallWrap setLuaArgs(Object[] luaValues) {
            try {
                UnmodifiableIterator it = Iterators.forArray((Object[])luaValues);
                try {
                    for (Argument arg : MethodDeclaration.this.luaArgs) {
                        Object value = arg.convert((Iterator<Object>)it);
                        this.setArg(arg.javaArgIndex, value);
                    }
                    Preconditions.checkState((!it.hasNext() ? 1 : 0) != 0, (Object)"Too many arguments!");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.log((Level)Level.TRACE, (Throwable)e, (String)"Trying to access arg index, args = %s", (Object[])new Object[]{Arrays.toString(luaValues)});
                    throw new IllegalArgumentException(String.format("Invalid Lua parameter count, needs %s, got %s", MethodDeclaration.this.luaArgs.size(), luaValues.length));
                }
            }
            catch (Exception e) {
                throw new AdapterLogicException(e);
            }
            return this;
        }

        @Override
        public Object[] call() throws Exception {
            Object result;
            for (int i = 0; i < this.args.length; ++i) {
                Preconditions.checkState((boolean)this.isSet.contains(i), (String)"Parameter %s value not set", (Object[])new Object[]{i});
            }
            try {
                result = MethodDeclaration.this.method.invoke(this.target, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable wrapper = e.getCause();
                throw Throwables.propagate((Throwable)(wrapper != null ? wrapper : e));
            }
            if (result instanceof IMultiReturn) {
                return MethodDeclaration.this.validateResult(((IMultiReturn)result).getObjects());
            }
            return MethodDeclaration.this.validateResult(new Object[]{result});
        }
    }

    private static enum ArgParseState {
        JAVA_REQUIRED,
        JAVA_OPTIONAL,
        LUA_REQUIRED,
        LUA_OPTIONAL;

    }

    public static class ArgumentDefinitionException
    extends IllegalStateException {
        private static final long serialVersionUID = -6428721405547878927L;

        public ArgumentDefinitionException(int argument, Throwable cause) {
            super(String.format("Failed to parse annotations on argument %d", argument), cause);
        }
    }
}

