/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.LuaArgType;

public class Argument {
    public final String name;
    public final String description;
    public final LuaArgType luaType;
    public final Class<?> javaType;
    final int javaArgIndex;

    public Argument(String name, String description, LuaArgType luaType, Class<?> javaType, int javaArgIndex) {
        this.name = name;
        this.description = description;
        this.luaType = luaType;
        this.javaArgIndex = javaArgIndex;
        this.javaType = this.getArgType(javaType);
    }

    protected Class<?> getArgType(Class<?> javaArgClass) {
        return javaArgClass;
    }

    public Object convert(Iterator<Object> args) {
        Preconditions.checkState((boolean)args.hasNext(), (String)"Not enough arguments, first missing: %s", (Object[])new Object[]{this.name});
        Object arg = args.next();
        Preconditions.checkNotNull((Object)arg, (String)"Argument %s cannot be null", (Object[])new Object[]{this.name});
        return this.convertSingleArg(arg);
    }

    protected final Object convertSingleArg(Object o) {
        if (o == null) {
            return null;
        }
        Object converted = TypeConversionRegistry.INSTANCE.fromLua(o, this.javaType);
        Preconditions.checkNotNull((Object)converted, (String)"Failed to convert arg '%s' value '%s' to '%s'", (Object[])new Object[]{this.name, o, this.javaType.getSimpleName()});
        return converted;
    }

    public Map<String, Object> describe() {
        HashMap result = Maps.newHashMap();
        result.put("type", this.luaType.toString());
        result.put("name", this.name);
        result.put("description", this.description);
        return result;
    }

    public String toString() {
        return this.name;
    }
}

