/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;

public class MethodsListerHelper<E extends IMethodExecutor> {
    private final Map<String, E> methods;
    private final Set<String> sources;

    public MethodsListerHelper(Map<String, E> methods, Set<String> sources) {
        this.methods = methods;
        this.sources = sources;
    }

    @LuaCallable(returnTypes={LuaReturnType.STRING}, description="List all the methods available")
    public String listMethods() {
        ArrayList info = Lists.newArrayList();
        for (Map.Entry<String, E> e : this.methods.entrySet()) {
            IDescriptable m = ((IMethodExecutor)e.getValue()).description();
            info.add(e.getKey() + m.signature());
        }
        return Joiner.on((String)", ").join((Iterable)info);
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="List all method sources")
    public Map<String, Boolean> listSources() {
        HashMap result = Maps.newHashMap();
        for (String source : this.sources) {
            result.put(source, Boolean.TRUE);
        }
        return result;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE}, description="Get a complete table of information about all available methods")
    public Map<?, ?> getAdvancedMethodsData() {
        HashMap info = Maps.newHashMap();
        for (Map.Entry<String, E> e : this.methods.entrySet()) {
            IDescriptable m = ((IMethodExecutor)e.getValue()).description();
            info.put(e.getKey(), m.describe());
        }
        return info;
    }
}

