/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dan200.computercraft.api.lua.ILuaObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.composed.ClassMethodsComposer;
import openperipheral.adapter.composed.ClassMethodsListBuilder;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.object.LuaObjectWrapper;
import openperipheral.adapter.object.ObjectAdapterWrapper;
import openperipheral.adapter.object.ObjectMethodsListBuilder;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralExternalAdapterWrapper;
import openperipheral.adapter.peripheral.PeripheralInlineAdapterWrapper;
import openperipheral.adapter.peripheral.PeripheralMethodsListBuilder;
import openperipheral.api.IAdapter;
import openperipheral.api.IAdapterWithConstraints;
import openperipheral.api.IObjectAdapter;
import openperipheral.api.IPeripheralAdapter;

public abstract class AdapterManager<E extends IMethodExecutor> {
    private static final ClassMethodsComposer<IObjectMethodExecutor> OBJECT_COMPOSER = new ClassMethodsComposer<IObjectMethodExecutor>(){

        @Override
        protected ClassMethodsListBuilder<IObjectMethodExecutor> createBuilder() {
            return new ObjectMethodsListBuilder();
        }
    };
    public static final AdapterManager<IObjectMethodExecutor> OBJECTS_MANAGER = new AdapterManager<IObjectMethodExecutor>(){

        @Override
        protected MethodMap<IObjectMethodExecutor> collectMethods(Class<?> targetClass) {
            return OBJECT_COMPOSER.createMethodsList(targetClass);
        }

        @Override
        protected AdapterWrapper<IObjectMethodExecutor> wrapExternalAdapter(IAdapter adapter) {
            return adapter instanceof IAdapterWithConstraints ? new ObjectAdapterWrapper.ExternalWithConstraints((IAdapterWithConstraints)adapter) : new ObjectAdapterWrapper.External(adapter);
        }

        @Override
        protected AdapterWrapper<IObjectMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new ObjectAdapterWrapper.Inline(targetClass);
        }
    };
    private static final ClassMethodsComposer<IPeripheralMethodExecutor> PERIPHERAL_COMPOSER = new ClassMethodsComposer<IPeripheralMethodExecutor>(){

        @Override
        protected ClassMethodsListBuilder<IPeripheralMethodExecutor> createBuilder() {
            return new PeripheralMethodsListBuilder();
        }
    };
    public static final AdapterManager<IPeripheralMethodExecutor> PERIPHERALS_MANAGER = new AdapterManager<IPeripheralMethodExecutor>(){

        @Override
        protected MethodMap<IPeripheralMethodExecutor> collectMethods(Class<?> targetClass) {
            return PERIPHERAL_COMPOSER.createMethodsList(targetClass);
        }

        @Override
        protected AdapterWrapper<IPeripheralMethodExecutor> wrapExternalAdapter(IAdapter adapter) {
            return adapter instanceof IAdapterWithConstraints ? new PeripheralExternalAdapterWrapper.WithConstraints((IAdapterWithConstraints)adapter) : new PeripheralExternalAdapterWrapper(adapter);
        }

        @Override
        protected AdapterWrapper<IPeripheralMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new PeripheralInlineAdapterWrapper(targetClass);
        }
    };
    private final Multimap<Class<?>, AdapterWrapper<E>> externalAdapters = HashMultimap.create();
    private final Map<Class<?>, AdapterWrapper<E>> internalAdapters = Maps.newHashMap();
    private final Map<Class<?>, MethodMap<E>> classes = Maps.newHashMap();
    private final Set<Class<?>> invalidClasses = Sets.newHashSet();

    public static boolean addObjectAdapter(IObjectAdapter adapter) {
        return OBJECTS_MANAGER.addAdapter(adapter);
    }

    public static boolean addPeripheralAdapter(IPeripheralAdapter adapter) {
        return PERIPHERALS_MANAGER.addAdapter(adapter);
    }

    public static void addInlinePeripheralAdapter(Class<?> cls) {
        PERIPHERALS_MANAGER.addInlineAdapter(cls);
    }

    public Set<Class<?>> getAllAdaptableClasses() {
        return Sets.union((Set)this.externalAdapters.keySet(), this.internalAdapters.keySet());
    }

    public Map<Class<?>, Collection<AdapterWrapper<E>>> listExternalAdapters() {
        return Collections.unmodifiableMap(this.externalAdapters.asMap());
    }

    public Map<Class<?>, AdapterWrapper<E>> listInternalAdapters() {
        return Collections.unmodifiableMap(this.internalAdapters);
    }

    public Map<Class<?>, MethodMap<E>> listCollectedClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    public boolean addAdapter(IAdapter adapter) {
        AdapterWrapper<E> wrapper;
        try {
            wrapper = this.wrapExternalAdapter(adapter);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Something went terribly wrong while adding internal adapter '%s'. It will be disabled", (Object[])new Object[]{adapter.getClass()});
            return false;
        }
        Class<?> targetCls = adapter.getTargetClass();
        Preconditions.checkArgument((!Object.class.equals(targetCls) ? 1 : 0) != 0, (Object)"Can't add adapter for Object class");
        Log.trace((String)"Registering %s adapter (source id: %s) for %s", (Object[])new Object[]{wrapper.describe(), wrapper.source(), targetCls});
        this.externalAdapters.put(targetCls, wrapper);
        return true;
    }

    public void addInlineAdapter(Class<?> targetCls) {
        AdapterWrapper<E> wrapper = this.wrapInlineAdapter(targetCls);
        Log.trace((String)"Registering %s adapter (source id: %s) adapter for %s", (Object[])new Object[]{wrapper.describe(), wrapper.source(), targetCls});
        this.internalAdapters.put(targetCls, wrapper);
    }

    public MethodMap<E> getAdaptedClass(Class<?> targetCls) {
        if (this.invalidClasses.contains(targetCls)) {
            throw new InvalidClassException();
        }
        MethodMap<E> value = this.classes.get(targetCls);
        if (value == null) {
            try {
                value = this.collectMethods(targetCls);
            }
            catch (Throwable t) {
                this.invalidClasses.add(targetCls);
                throw new InvalidClassException(t);
            }
            this.classes.put(targetCls, value);
        }
        return value;
    }

    public Collection<AdapterWrapper<E>> getExternalAdapters(Class<?> targetCls) {
        return Collections.unmodifiableCollection(this.externalAdapters.get(targetCls));
    }

    public AdapterWrapper<E> getInlineAdapter(Class<?> targetCls) {
        AdapterWrapper<E> wrapper = this.internalAdapters.get(targetCls);
        if (wrapper == null) {
            wrapper = this.wrapInlineAdapter(targetCls);
            this.internalAdapters.put(targetCls, wrapper);
        }
        return wrapper;
    }

    protected abstract MethodMap<E> collectMethods(Class<?> var1);

    protected abstract AdapterWrapper<E> wrapExternalAdapter(IAdapter var1);

    protected abstract AdapterWrapper<E> wrapInlineAdapter(Class<?> var1);

    public static ILuaObject wrapObject(Object o) {
        return LuaObjectWrapper.wrap(OBJECTS_MANAGER, o);
    }

    public static class InvalidClassException
    extends RuntimeException {
        private static final long serialVersionUID = 5722017683388067641L;

        private InvalidClassException() {
        }

        private InvalidClassException(Throwable cause) {
            super(cause);
        }
    }
}

