/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.ApiImplementation;
import openperipheral.ApiSingleton;
import openperipheral.TypeConversionRegistry;
import openperipheral.adapter.AdapterFactoryWrapper;
import openperipheral.adapter.AdapterRegistryWrapper;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.api.ApiAccess;
import openperipheral.api.IApiInterface;
import openperipheral.meta.EntityMetadataBuilder;
import openperipheral.meta.ItemStackMetadataBuilder;

public class ApiProvider
implements ApiAccess.ApiProvider {
    private final Map<Class<? extends IApiInterface>, IApiInstanceProvider> PROVIDERS = Maps.newHashMap();

    private static void listAllImplementedApis(Collection<Class<? extends IApiInterface>> output, Class<?> ... intfs) {
        for (Class<?> cls : intfs) {
            Preconditions.checkArgument((boolean)cls.isInterface());
            if (cls == IApiInterface.class || !IApiInterface.class.isAssignableFrom(cls)) continue;
            output.add(cls);
        }
    }

    private static void addAllInterfaces(Set<Class<? extends IApiInterface>> interfaces) {
        Class cls;
        LinkedList queue = Lists.newLinkedList(interfaces);
        while ((cls = (Class)queue.poll()) != null) {
            interfaces.add(cls);
            ApiProvider.listAllImplementedApis(queue, cls.getInterfaces());
        }
    }

    private void registerInterfaces(Class<? extends IApiInterface> cls, IApiInstanceProvider provider, boolean includeSuper) {
        HashSet implemented = Sets.newHashSet();
        ApiProvider.listAllImplementedApis(implemented, cls.getInterfaces());
        if (includeSuper) {
            ApiProvider.addAllInterfaces(implemented);
        }
        for (Class impl : implemented) {
            IApiInstanceProvider prev = this.PROVIDERS.put(impl, provider);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Conflict on interface %s", (Object[])new Object[]{impl});
        }
    }

    private void registerClass(Class<? extends IApiInterface> cls) {
        Preconditions.checkArgument((!Modifier.isAbstract(cls.getModifiers()) ? 1 : 0) != 0);
        ApiImplementation meta = cls.getAnnotation(ApiImplementation.class);
        Preconditions.checkNotNull((Object)meta);
        IApiInstanceProvider provider = meta.cacheable() ? new SingleInstanceProvider(cls) : new NewInstanceProvider(cls);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    private void registerInstance(IApiInterface obj) {
        Class<?> cls = obj.getClass();
        ApiSingleton meta = cls.getAnnotation(ApiSingleton.class);
        Preconditions.checkNotNull((Object)meta);
        SingletonProvider provider = new SingletonProvider(obj);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    private ApiProvider() {
        this.registerClass(AdapterFactoryWrapper.class);
        this.registerClass(AdapterRegistryWrapper.class);
        this.registerClass(EntityMetadataBuilder.class);
        this.registerClass(ItemStackMetadataBuilder.class);
        this.registerInstance(TypeConversionRegistry.INSTANCE);
        this.registerInstance(TileEntityBlacklist.INSTANCE);
    }

    @Override
    public <T extends IApiInterface> T getApi(Class<T> cls) {
        IApiInstanceProvider provider = this.PROVIDERS.get(cls);
        Preconditions.checkNotNull((Object)provider, (String)"Can't get implementation for class %s", (Object[])new Object[]{cls});
        return (T)provider.getInterface();
    }

    @Override
    public <T extends IApiInterface> boolean isApiPresent(Class<T> cls) {
        return this.PROVIDERS.containsKey(cls);
    }

    static void installApi() {
        String apiSource;
        String presentApiVersion;
        try {
            presentApiVersion = "2.2";
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get OpenPeripheralCore API version, class missing?", t);
        }
        try {
            apiSource = ApiAccess.class.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable t) {
            apiSource = "<unknown, see logs>";
            Log.severe((Throwable)t, (String)"Failed to get OpenPeripheralCore API source", (Object[])new Object[0]);
        }
        Preconditions.checkState((boolean)"2.2".equals(presentApiVersion), (String)"OpenPeripheralCore version mismatch, should be %s, is %s (ApiAccess source: %s)", (Object[])new Object[]{"2.2", presentApiVersion, apiSource});
        try {
            ApiAccess.init(new ApiProvider());
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to register OpenPeripheralCore API provider (ApiAccess source: %s)", apiSource), t);
        }
        Log.info((String)"OPC API v. %s provideded by OpenPeripheralCore, (ApiAccess source: %s)", (Object[])new Object[]{presentApiVersion, apiSource});
    }

    private static class SingletonProvider
    implements IApiInstanceProvider {
        private final IApiInterface obj;

        public SingletonProvider(IApiInterface obj) {
            this.obj = obj;
        }

        @Override
        public IApiInterface getInterface() {
            return this.obj;
        }
    }

    private static class NewInstanceProvider
    implements IApiInstanceProvider {
        private final Class<? extends IApiInterface> cls;

        public NewInstanceProvider(Class<? extends IApiInterface> cls) {
            this.cls = cls;
        }

        @Override
        public IApiInterface getInterface() {
            try {
                return this.cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    private static class SingleInstanceProvider
    implements IApiInstanceProvider {
        private final IApiInterface instance;

        public SingleInstanceProvider(Class<? extends IApiInterface> cls) {
            try {
                this.instance = cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public IApiInterface getInterface() {
            return this.instance;
        }
    }

    private static interface IApiInstanceProvider {
        public IApiInterface getInterface();
    }
}

