/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars;

import com.google.common.collect.MapMaker;
import com.google.common.math.IntMath;
import cpw.mods.compactsolars.CompactSolarType;
import cpw.mods.compactsolars.CompactSolars;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

public class ItemSolarHat
extends ItemArmor
implements ISpecialArmor {
    private static Random random = new Random();
    private static Map<EntityPlayer, PlayerState> playerState = new MapMaker().weakKeys().makeMap();
    private CompactSolarType type;

    public ItemSolarHat(CompactSolarType type) {
        super(EnumHelper.addArmorMaterial((String)"COMPACTSOLARHAT", (int)1, (int[])new int[]{1, 1, 1, 1}, (int)1), 0, 0);
        this.type = type;
        this.func_77655_b("compactsolars:" + type.hatName);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layerType) {
        return this.type.hatTexture.toString();
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        boolean theSunIsVisible;
        if (worldObj.field_72995_K || worldObj.field_73011_w.field_76576_e) {
            return;
        }
        if (CompactSolars.productionRate != 1 && random.nextInt(CompactSolars.productionRate) != 0) {
            return;
        }
        int xCoord = MathHelper.func_76128_c((double)player.field_70165_t);
        int zCoord = MathHelper.func_76128_c((double)player.field_70161_v);
        boolean isRaining = false;
        if (!playerState.containsKey(player)) {
            playerState.put(player, new PlayerState());
        }
        PlayerState state = playerState.get(player);
        if (worldObj.func_82737_E() % 20L == 0L) {
            boolean canRain;
            state.canRain = canRain = worldObj.func_72959_q().func_76935_a(xCoord, zCoord).func_76744_g() > 0;
        }
        isRaining = state.canRain && (worldObj.func_72896_J() || worldObj.func_72911_I());
        boolean bl = theSunIsVisible = worldObj.func_72935_r() && !isRaining && worldObj.func_72937_j(xCoord, MathHelper.func_76128_c((double)player.field_70163_u) + 1, zCoord);
        if (!theSunIsVisible) {
            return;
        }
        int available = this.type.getOutput();
        for (ItemStack is : player.field_71071_by.field_70460_b) {
            if (is == itemStack || is == null || !(is.func_77973_b() instanceof IElectricItem)) continue;
            IElectricItem electricItem = (IElectricItem)is.func_77973_b();
            available = (int)((double)available - ElectricItem.manager.charge(is, (double)available, this.type.ordinal() + 1, false, false));
        }
        state.buildUp = available <= 0 ? (state.buildUp += (long)IntMath.pow((int)2, (int)this.type.ordinal())) : Math.max(state.buildUp - (worldObj.func_82737_E() - state.lastTick), 0L);
        state.lastTick = worldObj.func_82737_E();
        int dose = IntMath.pow((int)10, (int)this.type.ordinal()) * 5;
        if (state.buildUp > (long)dose) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, dose >> 2, 0));
            state.buildUp -= (long)dose;
        }
    }

    public static void clearRaining() {
        playerState.clear();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a(this.type.hatItemTexture.toString());
    }

    private class PlayerState {
        boolean canRain;
        public long buildUp;
        public long lastTick;

        private PlayerState() {
        }
    }
}

