/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars;

import com.google.common.base.Throwables;
import cpw.mods.compactsolars.BlockCompactSolar;
import cpw.mods.compactsolars.ItemSolarHat;
import cpw.mods.compactsolars.TileEntityCompactSolar;
import cpw.mods.compactsolars.TileEntityCompactSolarHV;
import cpw.mods.compactsolars.TileEntityCompactSolarMV;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public enum CompactSolarType {
    LV(8, 32, "Low Voltage Solar Array", "lvTransformer", TileEntityCompactSolar.class, "lvHat"),
    MV(64, 128, "Medium Voltage Solar Array", "mvTransformer", TileEntityCompactSolarMV.class, "mvHat"),
    HV(512, 512, "High Voltage Solar Array", "hvTransformer", TileEntityCompactSolarHV.class, "hvHat");

    private int output;
    public Class<? extends TileEntityCompactSolar> clazz;
    public String friendlyName;
    public String transformerName;
    public final ResourceLocation hatTexture;
    public final String hatName;
    private ItemSolarHat item;
    public final ResourceLocation hatItemTexture;
    public final int outputPacketSize;
    public final int maxStorage;

    private CompactSolarType(int output, int outputPacketSize, String friendlyName, String transformerName, Class<? extends TileEntityCompactSolar> clazz, String hatTexture) {
        this.output = output;
        this.outputPacketSize = outputPacketSize;
        this.friendlyName = friendlyName;
        this.transformerName = transformerName;
        this.clazz = clazz;
        this.hatName = "solarHat" + this.name();
        this.hatTexture = new ResourceLocation("compactsolars", "textures/armor/" + hatTexture + ".png");
        this.hatItemTexture = new ResourceLocation("compactsolars", hatTexture);
        this.maxStorage = outputPacketSize << 1;
    }

    public static void generateRecipes(BlockCompactSolar block) {
        ItemStack solar;
        ItemStack parent = solar = IC2Items.getItem((String)"solarPanel");
        for (CompactSolarType typ : CompactSolarType.values()) {
            ItemStack targ = new ItemStack((Block)block, 1, typ.ordinal());
            ItemStack transformer = IC2Items.getItem((String)typ.transformerName);
            CompactSolarType.addRecipe(targ, "SSS", "SXS", "SSS", Character.valueOf('S'), parent, Character.valueOf('X'), transformer);
            parent = targ;
        }
    }

    private static void addRecipe(ItemStack target, Object ... args) {
        GameRegistry.addRecipe((ItemStack)target, (Object[])args);
    }

    public int getOutput() {
        return this.output;
    }

    public static TileEntityCompactSolar makeEntity(int metadata) {
        int solartype = metadata;
        try {
            TileEntityCompactSolar te = CompactSolarType.values()[solartype].clazz.newInstance();
            return te;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public int getTextureRow() {
        return this.ordinal();
    }

    public String tileEntityName() {
        return "CompactSolarType." + this.name();
    }

    public ItemSolarHat buildHat() {
        this.item = new ItemSolarHat(this);
        GameRegistry.registerItem((Item)this.item, (String)this.hatName);
        return this.item;
    }

    public static void buildHats() {
        for (CompactSolarType typ : CompactSolarType.values()) {
            typ.buildHat();
        }
    }

    public static void generateHatRecipes(BlockCompactSolar block) {
        ItemArmor ironHat = Items.field_151028_Y;
        for (CompactSolarType typ : CompactSolarType.values()) {
            ItemStack solarBlock = new ItemStack((Block)block, 0, typ.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)typ.item), (Object[])new Object[]{solarBlock, ironHat});
        }
    }
}

