/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import extracells.api.IECTileEntity;
import extracells.api.IFluidInterface;
import extracells.container.IContainerListener;
import extracells.crafting.CraftingPattern;
import extracells.crafting.CraftingPattern2;
import extracells.gridblock.ECFluidGridBlock;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.registries.ItemEnum;
import extracells.util.EmptyMeItemMonitor;
import extracells.waila.IWailaTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFluidInterface
extends TileEntity
implements IActionHost,
IFluidHandler,
IECTileEntity,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable,
ICraftingProvider,
IWailaTile {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    public FluidTank[] tanks = new FluidTank[6];
    public Integer[] fluidFilter = new Integer[this.tanks.length];
    public boolean doNextUpdate = false;
    private boolean wasIdle = false;
    private int tickCount = 0;
    private boolean update = false;
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private List<IAEItemStack> requestedItems = new ArrayList<IAEItemStack>();
    private List<IAEItemStack> removeList = new ArrayList<IAEItemStack>();
    public final FluidInterfaceInventory inventory;
    private IAEItemStack toExport = null;
    private List<IAEStack> export = new ArrayList<IAEStack>();
    private List<IAEStack> removeFromExport = new ArrayList<IAEStack>();
    private List<IAEStack> addToExport = new ArrayList<IAEStack>();
    private List<IAEItemStack> watcherList = new ArrayList<IAEItemStack>();
    private boolean isFirstGetGridNode = true;

    public TileEntityFluidInterface() {
        this.inventory = new FluidInterfaceInventory();
        this.gridBlock = new ECFluidGridBlock(this);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
            this.fluidFilter[i] = -1;
        }
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public void securityBreak() {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UNKNOWN || resource == null) {
            return 0;
        }
        if ((this.tanks[from.ordinal()].getFluid() == null || this.tanks[from.ordinal()].getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((int)this.fluidFilter[from.ordinal()])) {
            int added = this.tanks[from.ordinal()].fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tanks[from.ordinal()].fill(new FluidStack(resource.fluidID, resource.amount - filled), doFill);
        }
        if (filled > 0 && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        FluidStack drained = this.tanks[from.ordinal()].drain(maxDrain, doDrain);
        if (drained != null && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UNKNOWN && this.tanks[from.ordinal()].fill(new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        return new FluidTankInfo[]{this.tanks[from.ordinal()].getInfo()};
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this)) : (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    @Override
    public void setFilter(ForgeDirection side, Fluid fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        if (fluid == null) {
            this.fluidFilter[side.ordinal()] = -1;
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter[side.ordinal()] = fluid.getID();
        this.doNextUpdate = true;
    }

    @Override
    public Fluid getFilter(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return FluidRegistry.getFluid((int)this.fluidFilter[side.ordinal()]);
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.tanks[side.ordinal()];
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    @Override
    public void setFluidTank(ForgeDirection side, FluidStack fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.tanks[side.ordinal()].setFluid(fluid);
        this.doNextUpdate = true;
    }

    private void forceUpdate() {
        this.func_145831_w().func_147471_g(this.field_145848_d, this.field_145848_d, this.field_145849_e);
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public void func_145845_h() {
        if (this.func_145831_w() == null || this.func_145831_w().field_73011_w == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.update) {
            this.update = false;
            if (this.getGridNode(ForgeDirection.UNKNOWN) != null && this.getGridNode(ForgeDirection.UNKNOWN).getGrid() != null) {
                this.getGridNode(ForgeDirection.UNKNOWN).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(ForgeDirection.UNKNOWN)));
            }
        }
        this.pushItems();
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        this.tick();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("filter#" + i, this.fluidFilter[i].intValue());
        }
        if (!this.func_145830_o()) {
            return;
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tag.func_74782_a("nodes", (NBTBase)nodeTag);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        this.inventory.writeToNBT(inventory);
        tag.func_74782_a("inventory", (NBTBase)inventory);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (tag.func_74764_b("tank#" + i)) {
                this.tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
            }
            if (!tag.func_74764_b("filter#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("filter#" + i);
        }
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
            if (tag.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tag.func_74775_l("nodes"));
                node.updateState();
            }
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private void tick() {
        if (this.tickCount < 40 && this.wasIdle) {
            ++this.tickCount;
            return;
        }
        this.tickCount = 0;
        this.wasIdle = true;
        if (this.node == null) {
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return;
        }
        if (this.toExport != null) {
            storage.getItemInventory().injectItems((IAEStack)this.toExport, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            this.toExport = null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            int accepted;
            IAEFluidStack extracted;
            FluidStack s;
            if (this.tanks[i].getFluid() != null && FluidRegistry.getFluid((int)this.fluidFilter[i]) != this.tanks[i].getFluid().getFluid() && (s = this.tanks[i].drain(125, false)) != null) {
                IAEFluidStack notAdded = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(s.copy()), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (notAdded != null) {
                    int toAdd = (int)((long)s.amount - notAdded.getStackSize());
                    storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tanks[i].drain(toAdd, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                } else {
                    storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tanks[i].drain(s.amount, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                }
            }
            if (this.tanks[i].getFluid() != null && this.tanks[i].getFluid().getFluid() != FluidRegistry.getFluid((int)this.fluidFilter[i]) || FluidRegistry.getFluid((int)this.fluidFilter[i]) == null || (extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter[i]), 125)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this))) == null || (accepted = this.tanks[i].fill(extracted.getFluidStack(), false)) == 0) continue;
            this.tanks[i].fill(((IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter[i]), accepted)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this))).getFluidStack(), true);
            this.doNextUpdate = true;
            this.wasIdle = false;
        }
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            tag.func_74768_a("fluid#" + i, this.fluidFilter[i].intValue());
        }
        return tag;
    }

    public void readFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            if (!tag.func_74764_b("fluid#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("fluid#" + i);
        }
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.getGridNode(ForgeDirection.UNKNOWN) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getFluidInventory();
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.isBusy()) {
            return false;
        }
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.node.getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.export.add((IAEStack)extractFluid);
            }
            for (IAEItemStack s : patter.getCondensedInputs()) {
                if (s == null) continue;
                if (s.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    this.toExport = s.copy();
                    continue;
                }
                this.export.add((IAEStack)s);
            }
        }
        return true;
    }

    public boolean isBusy() {
        return !this.export.isEmpty();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPatternDetails>();
        for (ItemStack currentPatternStack : this.inventory.inv) {
            ICraftingPatternItem currentPattern;
            if (currentPatternStack == null || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b()) == null || currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w()) == null) continue;
            CraftingPattern2 pattern = new CraftingPattern2(currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w()));
            this.patternHandlers.add(pattern);
            craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern);
        }
    }

    private void pushItems() {
        ForgeDirection[] directions;
        for (IAEStack s : this.removeFromExport) {
            this.export.remove(s);
        }
        this.removeFromExport.clear();
        for (IAEStack s : this.addToExport) {
            this.export.add(s);
        }
        this.addToExport.clear();
        if (!this.func_145830_o() || this.export.isEmpty()) {
            return;
        }
        for (ForgeDirection dir : directions = ForgeDirection.VALID_DIRECTIONS) {
            int amount;
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null) continue;
            IAEStack stack0 = this.export.iterator().next();
            IAEStack stack = stack0.copy();
            if (stack instanceof IAEItemStack && tile instanceof IInventory) {
                ISidedInventory inv;
                if (tile instanceof ISidedInventory) {
                    inv = (ISidedInventory)tile;
                    for (int i : inv.func_94128_d(dir.getOpposite().ordinal())) {
                        if (!inv.func_102007_a(i, ((IAEItemStack)stack).getItemStack(), dir.getOpposite().ordinal())) continue;
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, ((IAEItemStack)stack).getItemStack());
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        if (!ItemStack.func_77970_a((ItemStack)inv.func_70301_a(i), (ItemStack)((IAEItemStack)stack).getItemStack())) continue;
                        int max = inv.func_70297_j_();
                        int current = inv.func_70301_a((int)i).field_77994_a;
                        int outStack = (int)stack.getStackSize();
                        if (max == current) continue;
                        if (current + outStack <= max) {
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.field_77994_a += outStack;
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a = max;
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        stack.setStackSize((long)(max - current));
                        this.addToExport.add(stack);
                        return;
                    }
                    continue;
                }
                inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (!inv.func_94041_b(i, ((IAEItemStack)stack).getItemStack())) continue;
                    if (inv.func_70301_a(i) == null) {
                        inv.func_70299_a(i, ((IAEItemStack)stack).getItemStack());
                        this.removeFromExport.add(stack0);
                        return;
                    }
                    if (!ItemStack.func_77970_a((ItemStack)inv.func_70301_a(i), (ItemStack)((IAEItemStack)stack).getItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a((int)i).field_77994_a;
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a += outStack;
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        return;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.field_77994_a = max;
                    inv.func_70299_a(i, s);
                    this.removeFromExport.add(stack0);
                    stack.setStackSize((long)(max - current));
                    this.addToExport.add(stack);
                    return;
                }
                continue;
            }
            if (!(stack instanceof IAEFluidStack) || !(tile instanceof IFluidHandler)) continue;
            IFluidHandler handler = (IFluidHandler)tile;
            IAEFluidStack fluid = (IAEFluidStack)stack;
            if (!handler.canFill(dir.getOpposite(), fluid.copy().getFluid()) || (amount = handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), false)) == 0) continue;
            if ((long)amount == fluid.getStackSize()) {
                handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), true);
                this.removeFromExport.add(stack0);
                continue;
            }
            IAEFluidStack f = fluid.copy();
            f.setStackSize(f.getStackSize() - (long)amount);
            FluidStack fl = fluid.getFluidStack().copy();
            fl.amount = amount;
            handler.fill(dir.getOpposite(), fl, true);
            this.removeFromExport.add(stack0);
            this.addToExport.add((IAEStack)f);
            return;
        }
    }

    @Override
    public IInventory getPatternInventory() {
        return this.inventory;
    }

    @Override
    public List<String> getWailaBody(List<String> list, NBTTagCompound tag, ForgeDirection side) {
        int i;
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return list;
        }
        list.add(StatCollector.func_74838_a((String)("extracells.tooltip.direction." + side.ordinal())));
        FluidTank[] tanks = new FluidTank[6];
        for (i = 0; i < tanks.length; ++i) {
            tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
        }
        for (i = 0; i < tanks.length; ++i) {
            if (!tag.func_74764_b("tank#" + i)) continue;
            tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
        }
        FluidTank tank = tanks[side.ordinal()];
        if (tank == null || tank.getFluid() == null || tank.getFluid().getFluid() == null) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB / 10000mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + tank.getFluid().getLocalizedName());
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + tank.getFluidAmount() + "mB / 10000mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    private class FluidInterfaceInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidInterfaceInventory() {
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.inv[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            TileEntityFluidInterface.this.update = true;
        }

        public ItemStack func_70298_a(int slot, int amt) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amt) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amt);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            TileEntityFluidInterface.this.update = true;
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }

        public String func_145825_b() {
            return "inventory.fluidInterface";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public void func_70296_d() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            if (stack.func_77973_b() instanceof ICraftingPatternItem) {
                ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, TileEntityFluidInterface.this.func_145831_w());
                return details != null;
            }
            return false;
        }
    }
}

