/*
 * Decompiled with CFR 0.152.
 */
package extracells.registries;

import appeng.api.config.Upgrades;
import extracells.part.PartBattery;
import extracells.part.PartConversionMonitor;
import extracells.part.PartDrive;
import extracells.part.PartECBase;
import extracells.part.PartFluidExport;
import extracells.part.PartFluidImport;
import extracells.part.PartFluidInterface;
import extracells.part.PartFluidLevelEmitter;
import extracells.part.PartFluidPlaneAnnihilation;
import extracells.part.PartFluidPlaneFormation;
import extracells.part.PartFluidStorage;
import extracells.part.PartFluidTerminal;
import extracells.part.PartOreDictExporter;
import extracells.part.PartStorageMonitor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum PartEnum {
    FLUIDEXPORT("fluid.export", PartFluidExport.class, "fluid.IO", PartEnum.generatePair(Upgrades.CAPACITY, 2), PartEnum.generatePair(Upgrades.REDSTONE, 1), PartEnum.generatePair(Upgrades.SPEED, 2)),
    FLUIDIMPORT("fluid.import", PartFluidImport.class, "fluid.IO", PartEnum.generatePair(Upgrades.CAPACITY, 2), PartEnum.generatePair(Upgrades.REDSTONE, 1), PartEnum.generatePair(Upgrades.SPEED, 2)),
    FLUIDSTORAGE("fluid.storage", PartFluidStorage.class, null, PartEnum.generatePair(Upgrades.INVERTER, 1)),
    FLUIDTERMINAL("fluid.terminal", PartFluidTerminal.class),
    FLUIDLEVELEMITTER("fluid.levelemitter", PartFluidLevelEmitter.class),
    FLUIDPANEANNIHILATION("fluid.plane.annihilation", PartFluidPlaneAnnihilation.class, "fluid.plane"),
    FLUIDPANEFORMATION("fluid.plane.formation", PartFluidPlaneFormation.class, "fluid.plane"),
    DRIVE("drive", PartDrive.class),
    BATTERY("battery", PartBattery.class),
    INTERFACE("interface", PartFluidInterface.class),
    FLUIDMONITOR("fluid.monitor", PartStorageMonitor.class),
    FLUIDCONVERSIONMONITOR("fluid.conversion.monitor", PartConversionMonitor.class),
    OREDICTEXPORTBUS("oredict.export", PartOreDictExporter.class);

    private String unlocalizedName;
    private Class<? extends PartECBase> partClass;
    private String groupName;
    private Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();

    private PartEnum(String _unlocalizedName, Class<? extends PartECBase> _partClass, String _groupName, Pair<Upgrades, Integer> ... _upgrades) {
        this(_unlocalizedName, _partClass, _groupName);
        for (Pair<Upgrades, Integer> pair : _upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private PartEnum(String _unlocalizedName, Class<? extends PartECBase> _partClass, String _groupName) {
        this.unlocalizedName = "extracells.part." + _unlocalizedName;
        this.partClass = _partClass;
        this.groupName = _groupName == null || _groupName.isEmpty() ? null : "extracells." + _groupName;
    }

    private PartEnum(String _unlocalizedName, Class<? extends PartECBase> _partClass) {
        this(_unlocalizedName, _partClass, null);
    }

    public PartECBase newInstance(ItemStack partStack) throws IllegalAccessException, InstantiationException {
        PartECBase partECBase = this.partClass.newInstance();
        partECBase.initializePart(partStack);
        return partECBase;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getStatName() {
        return StatCollector.func_74838_a((String)(this.unlocalizedName + ".name"));
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Class<? extends PartECBase> getPartClass() {
        return this.partClass;
    }

    public static int getPartID(Class<? extends PartECBase> partClass) {
        for (int i = 0; i < PartEnum.values().length; ++i) {
            if (PartEnum.values()[i].getPartClass() != partClass) continue;
            return i;
        }
        return -1;
    }

    public static int getPartID(PartECBase partECBase) {
        return PartEnum.getPartID(partECBase.getClass());
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades _upgrade, int integer) {
        return new MutablePair((Object)_upgrade, (Object)integer);
    }
}

