/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.part.PartFluidIO;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidImport
extends PartFluidIO
implements IFluidHandler {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.IMPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.IMPORT_FRONT.getTexture(), side, side);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        ts.func_78380_c(0xF000F0);
        rh.renderInventoryFace(TextureManager.IMPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.IMPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.IMPORT_FRONT.getTextures()[0], side, side);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            ts.func_78380_c(0xF000F0);
        }
        rh.renderFace(x, y, z, TextureManager.IMPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean doWork(int rate, int TicksSinceLastCall) {
        int i;
        if (this.getFacingTank() == null || !this.isActive()) {
            return false;
        }
        boolean empty = true;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(this.filterFluids[4]);
        if (this.filterSize >= 1) {
            for (i = 1; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        if (this.filterSize >= 2) {
            for (i = 0; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        for (Fluid fluid : filter) {
            if (fluid == null) continue;
            empty = false;
            if (!this.fillToNetwork(fluid, rate * TicksSinceLastCall)) continue;
            return true;
        }
        if (empty) {
            return this.fillToNetwork(null, rate * TicksSinceLastCall);
        }
        return false;
    }

    private boolean fillToNetwork(Fluid fluid, int toDrain) {
        IFluidHandler facingTank = this.getFacingTank();
        ForgeDirection side = this.getSide();
        FluidStack drained = fluid == null ? facingTank.drain(side.getOpposite(), toDrain, false) : facingTank.drain(side.getOpposite(), new FluidStack(fluid, toDrain), false);
        if (drained == null || drained.amount <= 0 || drained.fluidID <= 0) {
            return false;
        }
        IAEFluidStack toFill = AEApi.instance().storage().createFluidStack(drained);
        IAEFluidStack notInjected = this.injectFluid(toFill, Actionable.MODULATE);
        if (notInjected != null) {
            int amount = (int)(toFill.getStackSize() - notInjected.getStackSize());
            if (amount > 0) {
                if (fluid == null) {
                    facingTank.drain(side.getOpposite(), amount, true);
                } else {
                    facingTank.drain(side.getOpposite(), new FluidStack(toFill.getFluid(), amount), true);
                }
                return true;
            }
            return false;
        }
        if (fluid == null) {
            facingTank.drain(side.getOpposite(), toFill.getFluidStack().amount, true);
        } else {
            facingTank.drain(side.getOpposite(), toFill.getFluidStack(), true);
        }
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        boolean redstonePowered = this.isRedstonePowered();
        if (resource == null || redstonePowered && this.getRedstoneMode() == RedstoneMode.LOW_SIGNAL || !redstonePowered && this.getRedstoneMode() == RedstoneMode.HIGH_SIGNAL) {
            return 0;
        }
        int drainAmount = Math.min(125 + this.speedState * 125, resource.amount);
        FluidStack toFill = new FluidStack(resource.fluidID, drainAmount);
        Actionable action = doFill ? Actionable.MODULATE : Actionable.SIMULATE;
        IAEFluidStack filled = this.injectFluid(AEApi.instance().storage().createFluidStack(toFill), action);
        if (filled == null) {
            return toFill.amount;
        }
        return toFill.amount - (int)filled.getStackSize();
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }
}

